# SGHI Medication - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Medication**

## Resource Profile: SGHI Medication 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/medication | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIMedication |

 
SGHI's Medication profile for Medication resource 

**Usages:**

* Refer to this Profile: [SGHI Medication](StructureDefinition-medication.md), [SGHI Medication Dispense](StructureDefinition-medicationdispense.md) and [SGHI MedicationRequest](StructureDefinition-medicationrequest.md)
* Examples for this Profile: [Medication/ExampleSGHIMedication](Medication-ExampleSGHIMedication.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/medication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medication.csv), [Excel](StructureDefinition-medication.xlsx), [Schematron](StructureDefinition-medication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medication",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/medication",
  "version" : "0.1.0",
  "name" : "SGHIMedication",
  "title" : "SGHI Medication",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "SGHI's Medication profile for Medication resource",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "min" : 1
      },
      {
        "id" : "Medication.identifier.use",
        "path" : "Medication.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "Medication.identifier.type",
        "path" : "Medication.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "Medication.identifier.system",
        "path" : "Medication.identifier.system",
        "min" : 1
      },
      {
        "id" : "Medication.identifier.value",
        "path" : "Medication.identifier.value",
        "min" : 1
      },
      {
        "id" : "Medication.identifier.assigner",
        "path" : "Medication.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "min" : 1
      },
      {
        "id" : "Medication.marketingAuthorizationHolder",
        "path" : "Medication.marketingAuthorizationHolder",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "Medication.doseForm",
        "path" : "Medication.doseForm",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/medication-form-codes"
        }
      },
      {
        "id" : "Medication.ingredient.item",
        "path" : "Medication.ingredient.item",
        "type" : [
          {
            "code" : "CodeableReference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/medication",
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/substance"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "Medication.ingredient.isActive",
        "path" : "Medication.ingredient.isActive",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.strength[x]",
        "path" : "Medication.ingredient.strength[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.strength[x]:strengthCodeableConcept",
        "path" : "Medication.ingredient.strength[x]",
        "sliceName" : "strengthCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      }
    ]
  }
}

```
