# SGHI EpisodeOfCare - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI EpisodeOfCare**

## Resource Profile: SGHI EpisodeOfCare 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIEpisodeOfCare |

 
An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time. 

**Usages:**

* Refer to this Profile: [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md) and [SGHI Encounter](StructureDefinition-encounter.md)
* Examples for this Profile: [EpisodeOfCare/ExampleSGHIEpisodeOfCare](EpisodeOfCare-ExampleSGHIEpisodeOfCare.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/episodeofcare)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-episodeofcare.csv), [Excel](StructureDefinition-episodeofcare.xlsx), [Schematron](StructureDefinition-episodeofcare.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "episodeofcare",
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare",
  "version" : "0.1.0",
  "name" : "SGHIEpisodeOfCare",
  "title" : "SGHI EpisodeOfCare",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "EpisodeOfCare",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/EpisodeOfCare",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "EpisodeOfCare",
        "path" : "EpisodeOfCare"
      },
      {
        "id" : "EpisodeOfCare.identifier",
        "path" : "EpisodeOfCare.identifier",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier.use",
        "path" : "EpisodeOfCare.identifier.use",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/identifier-use"
        }
      },
      {
        "id" : "EpisodeOfCare.identifier.type",
        "path" : "EpisodeOfCare.identifier.type",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.slade360.co.ke/fhir/ValueSet/default-identifier-types"
        }
      },
      {
        "id" : "EpisodeOfCare.identifier.system",
        "path" : "EpisodeOfCare.identifier.system",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier.value",
        "path" : "EpisodeOfCare.identifier.value",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.identifier.assigner",
        "path" : "EpisodeOfCare.identifier.assigner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "EpisodeOfCare.statusHistory",
        "path" : "EpisodeOfCare.statusHistory",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.patient",
        "path" : "EpisodeOfCare.patient",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/patient"
            ]
          }
        ]
      },
      {
        "id" : "EpisodeOfCare.managingOrganization",
        "path" : "EpisodeOfCare.managingOrganization",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
            ]
          }
        ]
      },
      {
        "id" : "EpisodeOfCare.period",
        "path" : "EpisodeOfCare.period",
        "min" : 1
      },
      {
        "id" : "EpisodeOfCare.referralRequest",
        "path" : "EpisodeOfCare.referralRequest",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/servicerequest"
            ]
          }
        ]
      }
    ]
  }
}

```
