<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile Dosage
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Dosage</sch:title>
    <sch:rule context="f:Dosage">
      <sch:assert test="count(f:timing) &gt;= 1">timing: minimum cardinality of 'timing' is 1</sch:assert>
      <sch:assert test="count(f:route) &gt;= 1">route: minimum cardinality of 'route' is 1</sch:assert>
      <sch:assert test="count(f:doseAndRate) &gt;= 1">doseAndRate: minimum cardinality of 'doseAndRate' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Dosage/f:doseAndRate/f:dose[x] 1</sch:title>
    <sch:rule context="f:Dosage/f:doseAndRate/f:dose[x]">
      <sch:assert test="count(f:comparator) &lt;= 0">comparator: maximum cardinality of 'comparator' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Dosage/f:doseAndRate/f:dose[x]/f:low 1</sch:title>
    <sch:rule context="f:Dosage/f:doseAndRate/f:dose[x]/f:low">
      <sch:assert test="count(f:comparator) &lt;= 0">comparator: maximum cardinality of 'comparator' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Dosage/f:doseAndRate/f:dose[x]/f:high 1</sch:title>
    <sch:rule context="f:Dosage/f:doseAndRate/f:dose[x]/f:high">
      <sch:assert test="count(f:comparator) &lt;= 0">comparator: maximum cardinality of 'comparator' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Dosage/f:doseAndRate/f:rate[x]/f:denominator 1</sch:title>
    <sch:rule context="f:Dosage/f:doseAndRate/f:rate[x]/f:denominator">
      <sch:assert test="count(f:comparator) &lt;= 0">comparator: maximum cardinality of 'comparator' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Dosage/f:doseAndRate/f:rate[x]/f:low 1</sch:title>
    <sch:rule context="f:Dosage/f:doseAndRate/f:rate[x]/f:low">
      <sch:assert test="count(f:comparator) &lt;= 0">comparator: maximum cardinality of 'comparator' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Dosage/f:doseAndRate/f:rate[x]/f:high 1</sch:title>
    <sch:rule context="f:Dosage/f:doseAndRate/f:rate[x]/f:high">
      <sch:assert test="count(f:comparator) &lt;= 0">comparator: maximum cardinality of 'comparator' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
