<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile Consent
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Consent</sch:title>
    <sch:rule context="f:Consent">
      <sch:assert test="count(f:identifier) &gt;= 1">identifier: minimum cardinality of 'identifier' is 1</sch:assert>
      <sch:assert test="count(f:category) &gt;= 1">category: minimum cardinality of 'category' is 1</sch:assert>
      <sch:assert test="count(f:subject) &gt;= 1">subject: minimum cardinality of 'subject' is 1</sch:assert>
      <sch:assert test="count(f:date) &gt;= 1">date: minimum cardinality of 'date' is 1</sch:assert>
      <sch:assert test="count(f:grantor) &gt;= 1">grantor: minimum cardinality of 'grantor' is 1</sch:assert>
      <sch:assert test="count(f:grantor) &lt;= 1">grantor: maximum cardinality of 'grantor' is 1</sch:assert>
      <sch:assert test="count(f:grantee) &gt;= 1">grantee: minimum cardinality of 'grantee' is 1</sch:assert>
      <sch:assert test="count(f:grantee) &lt;= 1">grantee: maximum cardinality of 'grantee' is 1</sch:assert>
      <sch:assert test="count(f:manager) &gt;= 1">manager: minimum cardinality of 'manager' is 1</sch:assert>
      <sch:assert test="count(f:controller) &gt;= 1">controller: minimum cardinality of 'controller' is 1</sch:assert>
      <sch:assert test="count(f:controller) &lt;= 1">controller: maximum cardinality of 'controller' is 1</sch:assert>
      <sch:assert test="count(f:verification) &gt;= 1">verification: minimum cardinality of 'verification' is 1</sch:assert>
      <sch:assert test="count(f:decision) &gt;= 1">decision: minimum cardinality of 'decision' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Consent/f:identifier</sch:title>
    <sch:rule context="f:Consent/f:identifier">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
      <sch:assert test="count(f:type) &lt;= 1">type: maximum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:system) &gt;= 1">system: minimum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:system) &lt;= 1">system: maximum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:value) &gt;= 1">value: minimum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:period) &lt;= 1">period: maximum cardinality of 'period' is 1</sch:assert>
      <sch:assert test="count(f:assigner) &gt;= 1">assigner: minimum cardinality of 'assigner' is 1</sch:assert>
      <sch:assert test="count(f:assigner) &lt;= 1">assigner: maximum cardinality of 'assigner' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Consent/f:verification</sch:title>
    <sch:rule context="f:Consent/f:verification">
      <sch:assert test="count(f:verifiedBy) &gt;= 1">verifiedBy: minimum cardinality of 'verifiedBy' is 1</sch:assert>
      <sch:assert test="count(f:verifiedWith) &gt;= 1">verifiedWith: minimum cardinality of 'verifiedWith' is 1</sch:assert>
      <sch:assert test="count(f:verificationDate) &gt;= 1">verificationDate: minimum cardinality of 'verificationDate' is 1</sch:assert>
      <sch:assert test="count(f:verificationDate) &lt;= 1">verificationDate: maximum cardinality of 'verificationDate' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
