# SGHI CodeableReference - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI CodeableReference**

## Data Type Profile: SGHI CodeableReference 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHICodeableReference |

 
A reusable CodeableReference within SGHI systems 

**Usages:**

* Use this DataType Profile: [SGHI AllergyIntolerance](StructureDefinition-allergyintolerance.md), [SGHI Appointment Profile](StructureDefinition-appointment.md), [SGHI Care Plan](StructureDefinition-careplan.md), [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md)...Show 9 more,[SGHI Encounter](StructureDefinition-encounter.md),[SGHI Medication](StructureDefinition-medication.md),[SGHI Medication Dispense](StructureDefinition-medicationdispense.md),[SGHI MedicationRequest](StructureDefinition-medicationrequest.md),[SGHI Procedure](StructureDefinition-procedure.md),[SGHI RiskAssessment](StructureDefinition-riskassessment.md),[SGHI ServiceRequest](StructureDefinition-servicerequest.md),[SGHI Substance](StructureDefinition-substance.md)and[SGHI Task](StructureDefinition-task.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/codeable-reference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-codeable-reference.csv), [Excel](StructureDefinition-codeable-reference.xlsx), [Schematron](StructureDefinition-codeable-reference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "codeable-reference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "has-target"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "do-translations"
    }
  ],
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeable-reference",
  "version" : "0.1.0",
  "name" : "SGHICodeableReference",
  "title" : "SGHI CodeableReference",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A reusable CodeableReference within SGHI systems",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "CodeableReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CodeableReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CodeableReference.concept",
        "path" : "CodeableReference.concept",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/codeableconcept"
            ]
          }
        ]
      },
      {
        "id" : "CodeableReference.reference",
        "path" : "CodeableReference.reference",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ]
          }
        ]
      }
    ]
  }
}

```
