# SGHI Attachment - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Attachment**

## Data Type Profile: SGHI Attachment 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/attachment | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIAttachment |

 
A custom document used for capturing the source of consent 

**Usages:**

* Use this DataType Profile: [SGHI Consent](StructureDefinition-consent.md) and [SGHI Observation](StructureDefinition-observation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/attachment)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-attachment.csv), [Excel](StructureDefinition-attachment.xlsx), [Schematron](StructureDefinition-attachment.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "attachment",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "do-translations"
    }
  ],
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/attachment",
  "version" : "0.1.0",
  "name" : "SGHIAttachment",
  "title" : "SGHI Attachment",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A custom document used for capturing the source of consent",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Attachment",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Attachment",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Attachment",
        "path" : "Attachment"
      },
      {
        "id" : "Attachment.contentType",
        "path" : "Attachment.contentType",
        "min" : 1,
        "patternCode" : "application/json"
      },
      {
        "id" : "Attachment.url",
        "path" : "Attachment.url",
        "min" : 1
      },
      {
        "id" : "Attachment.creation",
        "path" : "Attachment.creation",
        "min" : 1
      }
    ]
  }
}

```
