# SGHI Annotation - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Annotation**

## Data Type Profile: SGHI Annotation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/StructureDefinition/annotation | *Version*:0.1.0 |
| Draft as of 2026-01-09 | *Computable Name*:SGHIAnnotation |

 
A text note which also contains information about who made the statement and when. 

**Usages:**

* Use this DataType Profile: [SGHI Procedure](StructureDefinition-procedure.md) and [SGHI RiskAssessment](StructureDefinition-riskassessment.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/silfhirprofileig|current/StructureDefinition/annotation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-annotation.csv), [Excel](StructureDefinition-annotation.xlsx), [Schematron](StructureDefinition-annotation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "annotation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "has-size"
    }
  ],
  "url" : "https://fhir.slade360.co.ke/fhir/StructureDefinition/annotation",
  "version" : "0.1.0",
  "name" : "SGHIAnnotation",
  "title" : "SGHI Annotation",
  "status" : "draft",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A text note which also contains information about who made the statement and when.",
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Annotation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Annotation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Annotation",
        "path" : "Annotation"
      },
      {
        "id" : "Annotation.author[x]",
        "path" : "Annotation.author[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Annotation.author[x]:authorReference",
        "path" : "Annotation.author[x]",
        "sliceName" : "authorReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://fhir.slade360.co.ke/fhir/StructureDefinition/reference"
            ],
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Practitioner",
              "http://hl7.org/fhir/StructureDefinition/PractitionerRole"
            ]
          }
        ]
      },
      {
        "id" : "Annotation.time",
        "path" : "Annotation.time",
        "min" : 1
      }
    ]
  }
}

```
