# ExampleSGHISpecimen - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHISpecimen**

## Example Specimen: ExampleSGHISpecimen

Profile: [SGHI Specimen](StructureDefinition-specimen.md)

**identifier**: Medical Record Number/SPECIMEN1234 (use: official, )

**accessionIdentifier**: Medical Record Number/ACCESID9080 (use: official, )

**status**: Unavailable

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**receivedTime**: 2025-01-01 10:30:00+0000

**role**: Electronic QC

### Collections

| | |
| :--- | :--- |
| - | **Collected[x]** |
| * | 2025-01-01 10:30:00+0000 |

### Processings

| | |
| :--- | :--- |
| - | **Method** |
| * | Core Needle Biopsy |



## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "ExampleSGHISpecimen",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/specimen"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "SPECIMEN1234",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "accessionIdentifier" : {
    "use" : "official",
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "MR",
          "display" : "Medical Record Number"
        }
      ]
    },
    "value" : "ACCESID9080",
    "assigner" : {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  },
  "status" : "unavailable",
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "receivedTime" : "2025-01-01T10:30:00Z",
  "role" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/specimen-role",
          "code" : "e",
          "display" : "Electronic QC"
        }
      ]
    }
  ],
  "collection" : {
    "collectedDateTime" : "2025-01-01T10:30:00Z"
  },
  "processing" : [
    {
      "method" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/specimen-role",
            "code" : "cnb",
            "display" : "Core Needle Biopsy"
          }
        ]
      }
    }
  ]
}

```
