# ExampleSGHIRiskAssessment - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIRiskAssessment**

## Example RiskAssessment: ExampleSGHIRiskAssessment

Profile: [SGHI RiskAssessment](StructureDefinition-riskassessment.md)

**identifier**: Medical Record Number/3456789QWERTY

**status**: Registered

**code**: RiskAssessment contraindicated

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**basis**: `Example display`

### Predictions

| | |
| :--- | :--- |
| - | **QualitativeRisk** |
| * | Low likelihood |

**note**: @2025-02-01 10:30:00+0000

> 

The patient tolerated the procedure well and was discharged in stable condition.




## Resource Content

```json
{
  "resourceType" : "RiskAssessment",
  "id" : "ExampleSGHIRiskAssessment",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/riskassessment"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "3456789QWERTY",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "registered",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "183932001",
        "display" : "RiskAssessment contraindicated"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "basis" : [
    {
      "reference" : "Reference(QuestionnaireResponse)",
      "display" : "Example display"
    }
  ],
  "prediction" : [
    {
      "qualitativeRisk" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/risk-probability",
            "code" : "low",
            "display" : "Low likelihood"
          }
        ]
      }
    }
  ],
  "note" : [
    {
      "time" : "2025-02-01T10:30:00Z",
      "text" : "The patient tolerated the procedure well and was discharged in stable condition."
    }
  ]
}

```
