# ExampleSGHIProcedure - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIProcedure**

## Example Procedure: ExampleSGHIProcedure

Profile: [SGHI Procedure](StructureDefinition-procedure.md)

**identifier**: Medical Record Number/3456789QWERTY

**basedOn**: [ServiceRequest Procedure](ServiceRequest-ExampleSGHIServiceRequest.md)

**partOf**: [Observation Normal](Observation-ExampleSGHIObservation.md)

**status**: Preparation

**statusReason**: Procedure contraindicated

**category**: Psychiatry procedure or service

**code**: Procedure contraindicated

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**focus**: [John Doe (Test Patient)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**occurrence**: 2025-02-10 08:00:00+0000

**recorded**: 2025-02-10 08:00:00+0000

**recorder**: [Dr. John Doe (Test Practitioner)](Practitioner/987)

### Performers

| | | |
| :--- | :--- | :--- |
| - | **Actor** | **OnBehalfOf** |
| * | [Dr. Jane Smith (Test Practitioner)](Patient/123) | [Test Hospital (Example Organization)](Organization-ExampleSGHIOrganization.md) |

**location**: [Main Operating Room (Example Location)](Location-ExampleSGHILocation.md)

**bodySite**: Chest

**outcome**: Successful

**report**: [Diagnostic Report for 'Hospice care Note' for '->James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)'](DiagnosticReport-ExampleSGHIDiagnosticReport.md)

### Complications

| | |
| :--- | :--- |
| - | **Concept** |
| * | No current problems or disability |

**followUp**: Change of dressing

**note**: @2025-02-01 10:30:00+0000

> 

The patient tolerated the procedure well and was discharged in stable condition.




## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "ExampleSGHIProcedure",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/procedure"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "3456789QWERTY",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "ServiceRequest/ExampleSGHIServiceRequest"
    }
  ],
  "partOf" : [
    {
      "reference" : "Observation/ExampleSGHIObservation"
    }
  ],
  "status" : "preparation",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "183932001",
        "display" : "Procedure contraindicated"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "24642003",
          "display" : "Psychiatry procedure or service"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "183932001",
        "display" : "Procedure contraindicated"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "focus" : {
    "reference" : "Patient/ExampleSGHIPatient",
    "display" : "John Doe (Test Patient)"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "occurrenceDateTime" : "2025-02-10T08:00:00Z",
  "recorded" : "2025-02-10T08:00:00Z",
  "recorder" : {
    "reference" : "Practitioner/987",
    "display" : "Dr. John Doe (Test Practitioner)"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Patient/123",
        "display" : "Dr. Jane Smith (Test Practitioner)"
      },
      "onBehalfOf" : {
        "reference" : "Organization/ExampleSGHIOrganization",
        "display" : "Test Hospital (Example Organization)"
      }
    }
  ],
  "location" : {
    "reference" : "Location/ExampleSGHILocation",
    "display" : "Main Operating Room (Example Location)"
  },
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "1894",
          "display" : "Chest"
        }
      ]
    }
  ],
  "outcome" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "385669000",
        "display" : "Successful"
      }
    ]
  },
  "report" : [
    {
      "reference" : "DiagnosticReport/ExampleSGHIDiagnosticReport"
    }
  ],
  "complication" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "160245001",
            "display" : "No current problems or disability"
          }
        ]
      }
    }
  ],
  "followUp" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "18949003",
          "display" : "Change of dressing"
        }
      ]
    }
  ],
  "note" : [
    {
      "time" : "2025-02-01T10:30:00Z",
      "text" : "The patient tolerated the procedure well and was discharged in stable condition."
    }
  ]
}

```
