# ExampleSGHIPractitionerRole - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIPractitionerRole**

## Example PractitionerRole: ExampleSGHIPractitionerRole

Profile: [SGHI PractitionerRole](StructureDefinition-practitionerrole.md)

**identifier**: Medical Record Number/3456789QWERTY

**active**: true

**period**: 2025-01-01 --> 2025-01-31

**practitioner**: [Practitioner James Pond(official)](Practitioner-ExampleSGHIPractitioner.md)

**organization**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**code**: doctor

**specialty**: General practice

**location**: [Nairobi Hospital](Location-ExampleSGHILocation.md)

### Contacts

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Name** | **Telecom** | **Address** |
| * | Mary Pond(Official) | [+254-733-987654](tel:+254-733-987654) | Nairobi 98765 Kenya (work) |

> **availability**

### AvailableTimes

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **DaysOfWeek** | **AllDay** | **AvailableStartTime** | **AvailableEndTime** |
| * | Monday | false | 08:00:00 | 15:00:00 |

### NotAvailableTimes

| | | |
| :--- | :--- | :--- |
| - | **Description** | **During** |
| * | Away on business | 2025-07-07 --> 2025-10-07 |




## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "ExampleSGHIPractitionerRole",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "3456789QWERTY",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2025-01-01",
    "end" : "2025-01-31"
  },
  "practitioner" : {
    "reference" : "Practitioner/ExampleSGHIPractitioner"
  },
  "organization" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "code" : [
    {
      "coding" : [
        {
          "code" : "71388002",
          "display" : "doctor"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "264814015",
          "display" : "General practice"
        }
      ]
    }
  ],
  "location" : [
    {
      "reference" : "Location/ExampleSGHILocation",
      "display" : "Nairobi Hospital"
    }
  ],
  "contact" : [
    {
      "name" : [
        {
          "use" : "official",
          "text" : "Mary Pond",
          "family" : "Pond",
          "given" : ["Mary"]
        }
      ],
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+254-733-987654"
        }
      ],
      "address" : {
        "use" : "work",
        "type" : "physical",
        "city" : "Nairobi",
        "postalCode" : "98765",
        "country" : "Kenya"
      }
    }
  ],
  "availability" : [
    {
      "availableTime" : [
        {
          "daysOfWeek" : ["mon"],
          "allDay" : false,
          "availableStartTime" : "08:00:00",
          "availableEndTime" : "15:00:00"
        }
      ],
      "notAvailableTime" : [
        {
          "description" : "Away on business",
          "during" : {
            "start" : "2025-07-07",
            "end" : "2025-10-07"
          }
        }
      ]
    }
  ]
}

```
