# PlanDefinition Title - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PlanDefinition Title**

## PlanDefinition: PlanDefinition Title 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/PlanDefinition/ExampleSGHIPlanDefinition | *Version*:0.1.0 |
| Draft as of 2025-03-25 | *Computable Name*:PlanDefinition Name |
| *Other Identifiers:*Accession ID: APT123456 (use: official, ) | |
| **Usage:**[Example value reference](https://fhir.slade360.co.ke/fhir/ExampleSGHIOrganization) | |

* **Actions:**: **Url:**
  * : [PlanDefinition Title](PlanDefinition-ExampleSGHIPlanDefinition.md)
* **Actions:**: **Version:**
  * : 0.1.0
* **Actions:**: **Accession ID Identifier:**
  * : APT123456
* **Actions:**: **Title:**
  * : PlanDefinition Title
* **Actions:**: **Status:**
  * : draft
* **Actions:**: **Date:**
  * : 2025-03-25 09:00:00+0000
* **Actions:**: **Publisher:**
  * : Kathurima Kimathi



## Resource Content

```json
{
  "resourceType" : "PlanDefinition",
  "id" : "ExampleSGHIPlanDefinition",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/plandefinition"
    ]
  },
  "url" : "https://fhir.slade360.co.ke/fhir/PlanDefinition/ExampleSGHIPlanDefinition",
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "APT123456",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "version" : "0.1.0",
  "name" : "PlanDefinition Name",
  "title" : "PlanDefinition Title",
  "status" : "draft",
  "date" : "2025-03-25T09:00:00Z",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "useContext" : [
    {
      "code" : {
        "code" : "MR",
        "display" : "Medical Record Number"
      },
      "valueReference" : {
        "reference" : "ExampleSGHIOrganization",
        "display" : "Example value reference"
      }
    }
  ],
  "action" : [
    {
      "title" : "Example action title"
    }
  ]
}

```
