# Example SGHI Organization - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example SGHI Organization**

## Example Organization: Example SGHI Organization

Profile: [SGHI Organization](StructureDefinition-organization.md)

**identifier**: Passport number/123456789 (use: official, )

**active**: true

**type**: Healthcare Provider

**name**: SGHI Healthcare Organization

### Contacts

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **Purpose** | **Name** | **Telecom** | **Address** |
| * | Administrative | Jane Doe | [+254717355900](tel:+254717355900),[admin@sghi.org](mailto:admin@sghi.org) | Nairobi 98765 Kenya (work) |



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "ExampleSGHIOrganization",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/organization"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN",
            "display" : "Passport number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "123456789"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "code" : "prov",
          "display" : "Healthcare Provider"
        }
      ]
    }
  ],
  "name" : "SGHI Healthcare Organization",
  "contact" : [
    {
      "purpose" : {
        "coding" : [
          {
            "code" : "ADMIN",
            "display" : "Administrative"
          }
        ]
      },
      "name" : [
        {
          "text" : "Jane Doe"
        }
      ],
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+254717355900",
          "use" : "work"
        },
        {
          "system" : "email",
          "value" : "admin@sghi.org",
          "use" : "work"
        }
      ],
      "address" : {
        "use" : "work",
        "type" : "physical",
        "city" : "Nairobi",
        "postalCode" : "98765",
        "country" : "Kenya"
      }
    }
  ]
}

```
