# ExampleSGHIMedicationRequest - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIMedicationRequest**

## Example MedicationRequest: ExampleSGHIMedicationRequest

Profile: [SGHI MedicationRequest](StructureDefinition-medicationrequest.md)

**identifier**: Prescription Number/RX123456789 (use: official, )

**status**: Active

**intent**: Plan

**category**: Inpatient

**priority**: Routine

### Medications

| | |
| :--- | :--- |
| - | **Concept** |
| * | Hibiscus 500mg Capsule |

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**authoredOn**: 2025-01-22

**requester**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**recorder**: [Dr. John Doe](Practitioner-ExampleSGHIPractitioner.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Condition Hypertension](Condition-ExampleSGHICondition.md) |

**effectiveDosePeriod**: 2025-01-22 --> 2025-02-01

> **dosageInstruction****sequence**: 1**text**: Take 500 mg by mouth twice daily for 10 days after meals**additionalInstruction**:Take with food**patientInstruction**: Drink plenty of water with each dose**timing**: 2 per 1 day**asNeeded**: false**site**:Oral cavity structure**route**:Oral**method**:Swallow whole

### DoseAndRates

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Type** | **Dose[x]** | **Rate[x]** |
| * | Calculated dose | 500 mg(Details: UCUM codemg = 'mg') | 100 mL(Details: UCUM codemL = 'mL')/1 hr(Details: UCUM codeh = 'h') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "ExampleSGHIMedicationRequest",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/medicationrequest"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "RX",
            "display" : "Prescription Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "RX123456789",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "active",
  "intent" : "plan",
  "category" : [
    {
      "coding" : [
        {
          "code" : "inpatient",
          "display" : "Inpatient"
        }
      ]
    }
  ],
  "priority" : "routine",
  "medication" : {
    "concept" : {
      "coding" : [
        {
          "code" : "123456",
          "display" : "Hibiscus 500mg Capsule"
        }
      ]
    }
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "authoredOn" : "2025-01-22",
  "requester" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "recorder" : {
    "reference" : "Practitioner/ExampleSGHIPractitioner",
    "display" : "Dr. John Doe"
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Condition/ExampleSGHICondition"
      }
    }
  ],
  "effectiveDosePeriod" : {
    "start" : "2025-01-22",
    "end" : "2025-02-01"
  },
  "dosageInstruction" : [
    {
      "sequence" : 1,
      "text" : "Take 500 mg by mouth twice daily for 10 days after meals",
      "additionalInstruction" : [
        {
          "coding" : [
            {
              "system" : "http://example.org/fhir/CodeSystem/AdditionalInstructions",
              "code" : "withFood",
              "display" : "Take with food"
            }
          ]
        }
      ],
      "patientInstruction" : "Drink plenty of water with each dose",
      "timing" : {
        "repeat" : {
          "boundsPeriod" : {
            "start" : "2025-01-22",
            "end" : "2025-02-01"
          },
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "asNeeded" : false,
      "site" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "N",
            "display" : "Oral cavity structure"
          }
        ]
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
            "code" : "PO",
            "display" : "Oral"
          }
        ]
      },
      "method" : {
        "coding" : [
          {
            "system" : "http://example.org/fhir/CodeSystem/MedicationAdministrationMethod",
            "code" : "SWALLOW",
            "display" : "Swallow whole"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "calculated",
                "display" : "Calculated dose"
              }
            ]
          },
          "doseQuantity" : {
            "value" : 500,
            "unit" : "mg",
            "system" : "http://unitsofmeasure.org",
            "code" : "mg"
          },
          "rateRatio" : {
            "numerator" : {
              "value" : 100,
              "unit" : "mL",
              "system" : "http://unitsofmeasure.org",
              "code" : "mL"
            },
            "denominator" : {
              "value" : 1,
              "unit" : "hr",
              "system" : "http://unitsofmeasure.org",
              "code" : "h"
            }
          }
        }
      ]
    }
  ]
}

```
