# Example SGHI Episode of Care - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Example SGHI Episode of Care**

## Example EpisodeOfCare: Example SGHI Episode of Care

Profile: [SGHI EpisodeOfCare](StructureDefinition-episodeofcare.md)

**identifier**: Visit Number/EOC1234567890 (use: official, )

**status**: Active

### StatusHistories

| | | |
| :--- | :--- | :--- |
| - | **Status** | **Period** |
| * | Planned | 2025-01-01 --> 2025-01-31 |

> **reason**

### Values

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Condition Hypertension](Condition-ExampleSGHICondition.md) |


> **diagnosis**

### Conditions

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Condition Hypertension](Condition-ExampleSGHICondition.md) |


**patient**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**managingOrganization**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**period**: 2025-01-01 --> 2025-01-31

**referralRequest**: [ServiceRequest Procedure](ServiceRequest-ExampleSGHIServiceRequest.md)



## Resource Content

```json
{
  "resourceType" : "EpisodeOfCare",
  "id" : "ExampleSGHIEpisodeOfCare",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/episodeofcare"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "VN",
            "display" : "Visit Number"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "EOC1234567890",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "active",
  "statusHistory" : [
    {
      "status" : "planned",
      "period" : {
        "start" : "2025-01-01",
        "end" : "2025-01-31"
      }
    }
  ],
  "reason" : [
    {
      "value" : [
        {
          "reference" : {
            "reference" : "Condition/ExampleSGHICondition"
          }
        }
      ]
    }
  ],
  "diagnosis" : [
    {
      "condition" : [
        {
          "reference" : {
            "reference" : "Condition/ExampleSGHICondition"
          }
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "managingOrganization" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "period" : {
    "start" : "2025-01-01",
    "end" : "2025-01-31"
  },
  "referralRequest" : [
    {
      "reference" : "ServiceRequest/ExampleSGHIServiceRequest"
    }
  ]
}

```
