# ExampleSGHIDocumentReference - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExampleSGHIDocumentReference**

## Example DocumentReference: ExampleSGHIDocumentReference

Profile: [SGHI DocumentReference Profile.](StructureDefinition-documentreference.md)

**identifier**: Accession ID/Accession ID (use: official, )

**basedOn**: [Appointment: identifier = Accession ID: APT123456 (use: official, ); status = booked; specialty = General practice; appointmentType = Routine appointment; priority = Routine; start = 2023-11-25 09:00:00+0000; end = 2023-11-25 09:30:00+0000; created = 2023-11-20 10:00:00+0000; note = Patient requested morning appointment](Appointment-ExampleSGHIAppointment.md)

**status**: Current

**docStatus**: Final

**type**: Hospice care Note

**subject**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**context**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**date**: 2025-03-25 09:00:00+0000

**author**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

**custodian**: [Organization SGHI Healthcare Organization](Organization-ExampleSGHIOrganization.md)

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **Url** | **Title** |
| * | [https://example.com/sample-document.pdf](https://example.com/sample-document.pdf) | Example Document |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "ExampleSGHIDocumentReference",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/documentreference"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "Accession ID",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "basedOn" : [
    {
      "reference" : "Appointment/ExampleSGHIAppointment"
    }
  ],
  "status" : "current",
  "docStatus" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org/",
        "code" : "100018-1",
        "display" : "Hospice care Note"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/ExampleSGHIPatient"
  },
  "context" : [
    {
      "reference" : "Encounter/ExampleSGHIEncounter"
    }
  ],
  "date" : "2025-03-25T09:00:00Z",
  "author" : [
    {
      "reference" : "Organization/ExampleSGHIOrganization"
    }
  ],
  "custodian" : {
    "reference" : "Organization/ExampleSGHIOrganization"
  },
  "content" : [
    {
      "attachment" : {
        "url" : "https://example.com/sample-document.pdf",
        "title" : "Example Document"
      }
    }
  ]
}

```
