# CIEL to LOINC Observation Code Map - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CIEL to LOINC Observation Code Map**

## ConceptMap: CIEL to LOINC Observation Code Map 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*: |



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "CIELtoLOINCObservationMap",
  "url" : "https://fhir.slade360.co.ke/fhir/ConceptMap/CIELtoLOINCObservationMap",
  "version" : "0.1.0",
  "title" : "CIEL to LOINC Observation Code Map",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://fhir.slade360.co.ke/fhir/CodeSystem/retired-ciel-codes",
      "target" : "http://loinc.org",
      "element" : [
        {
          "code" : "5089",
          "display" : "Weight (kg)",
          "target" : [
            {
              "code" : "29463-7",
              "display" : "Body weight",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5086",
          "display" : "Diastolic blood pressure",
          "target" : [
            {
              "code" : "8462-4",
              "display" : "Diastolic blood pressure",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5085",
          "display" : "Systolic blood pressure",
          "target" : [
            {
              "code" : "8480-6",
              "display" : "Systolic blood pressure",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5087",
          "display" : "Pulse",
          "target" : [
            {
              "code" : "8867-4",
              "display" : "Heart rate",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1342",
          "display" : "Body mass index",
          "target" : [
            {
              "code" : "39156-5",
              "display" : "Body mass index (BMI)",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5090",
          "display" : "Height (cm)",
          "target" : [
            {
              "code" : "8302-2",
              "display" : "Body height",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "1343",
          "display" : "Mid-upper arm circumference",
          "target" : [
            {
              "code" : "56072-4",
              "display" : "Arm circumference C-mid upper",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5088",
          "display" : "Temperature (C)",
          "target" : [
            {
              "code" : "8310-5",
              "display" : "Body temperature",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5092",
          "display" : "Arterial blood oxygen saturation (pulse oximeter)",
          "target" : [
            {
              "code" : "59408-5",
              "display" : "Oxygen saturation in Arterial blood by Pulse oximetry",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "5242",
          "display" : "Respiratory rate",
          "target" : [
            {
              "code" : "9279-1",
              "display" : "Respiratory rate",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "163591",
          "display" : "Mammogram",
          "target" : [
            {
              "code" : "103892-6",
              "display" : "DBT Breast screening",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "162825",
          "display" : "Breast examination (text)",
          "target" : [
            {
              "code" : "10193-1",
              "display" : "Physical findings of Breasts Narrative",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "164805",
          "display" : "VIA screening for women aged between 30-49 years",
          "target" : [
            {
              "code" : "33717-0",
              "display" : "Cervical AndOr vaginal cytology study",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161288",
          "display" : "Ultrasound of chest",
          "target" : [
            {
              "code" : "24630-6",
              "display" : "US Chest",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "885",
          "display" : "Papanicolaou smear",
          "target" : [
            {
              "code" : "86662-4",
              "display" : "Pap smear tests - FPAR 2.0 set",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "159859",
          "display" : "Polymerase chain reaction, human papilloma virus, qualitative",
          "target" : [
            {
              "code" : "86658-2",
              "display" : "HPV tests - FPAR 2.0 set",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "168651",
          "display" : "Magnetic resonance imaging of breast",
          "target" : [
            {
              "code" : "30794-2",
              "display" : "MR Breast",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "162927",
          "display" : "Excisional biopsy of breast",
          "target" : [
            {
              "code" : "42448-1",
              "display" : "US Guidance for excisional biopsy of Breast",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "167166",
          "display" : "Immune stain study",
          "target" : [
            {
              "code" : "55229-9",
              "display" : "Immune stain study",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "167166",
          "display" : "Immune stain study",
          "target" : [
            {
              "code" : "55229-9",
              "display" : "Immune stain study",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160980",
          "display" : "Prostate examination (text)",
          "target" : [
            {
              "code" : "32465-7",
              "display" : "Physical findings of Prostate",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161939",
          "display" : "Whole blood",
          "target" : [
            {
              "code" : "100716-0",
              "display" : "Prostate specific Ag [Mass/volume] in DBS",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160406",
          "display" : "Bilateral",
          "target" : [
            {
              "code" : "26223-8",
              "display" : "US Extremity - bilateral",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "147661",
          "display" : "Benign Neoplasm of Skin of Breast",
          "target" : [
            {
              "code" : "63911-2",
              "display" : "Fibrocystic or other benign breast disease confirmed by breast biopsy [PhenX]",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "161290",
          "display" : "Ultrasound of right breast",
          "target" : [
            {
              "code" : "26216-2",
              "display" : "US Breast - right",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "154451",
          "display" : "abnormal Papanicolaou smear of vagina",
          "target" : [
            {
              "code" : "86662-4",
              "display" : "Pap smear tests - FPAR 2.0 set",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "166674",
          "display" : "High Risk",
          "target" : [
            {
              "code" : "86662-4",
              "display" : "Pap smear tests - FPAR 2.0 set",
              "relationship" : "equivalent"
            }
          ]
        },
        {
          "code" : "160338",
          "display" : "Patient referred for medical consultation",
          "target" : [
            {
              "code" : "57133-1",
              "display" : "Referral note",
              "relationship" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
