# SGHI Discharge Summary for John Doe - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Discharge Summary for John Doe**

## Example Composition: SGHI Discharge Summary for John Doe

Profile: [SGHI Composition](StructureDefinition-composition.md)

**identifier**: ID/QwErTy102938 (use: official, )

**status**: Final

**type**: Discharge Summary

**encounter**: [Encounter: identifier = Visit Number: VN123456789 (use: official, ); status = in-progress; class = Ambulatory](Encounter-ExampleSGHIEncounter.md)

**date**: 2025-06-03 14:30:00+0000

**author**: [James Pond(official) Male, DoB: 1990-07-15 ( Medical Record Number: 12345)](Patient-ExampleSGHIPatient.md)

**name**: SGHI Discharge Summary for John Doe

**title**: SGHI Discharge Summary for John Doe



## Resource Content

```json
{
  "resourceType" : "Composition",
  "id" : "ExampleSGHIComposition",
  "meta" : {
    "profile" : [
      "https://fhir.slade360.co.ke/fhir/StructureDefinition/composition"
    ]
  },
  "identifier" : [
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "ID",
            "display" : "ID"
          }
        ]
      },
      "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
      "value" : "QwErTy102938",
      "assigner" : {
        "reference" : "Organization/ExampleSGHIOrganization"
      }
    }
  ],
  "status" : "final",
  "type" : {
    "coding" : [
      {
        "system" : "http://example.org/CodeSystem/composition-type",
        "code" : "DISCHARGE_SUMMARY",
        "display" : "Discharge Summary"
      }
    ]
  },
  "subject" : [
    {
      "reference" : "Patient/ExampleSGHIPatient"
    }
  ],
  "encounter" : {
    "reference" : "Encounter/ExampleSGHIEncounter"
  },
  "date" : "2025-06-03T14:30:00Z",
  "author" : [
    {
      "reference" : "Patient/ExampleSGHIPatient"
    }
  ],
  "name" : "SGHI Discharge Summary for John Doe",
  "title" : "SGHI Discharge Summary for John Doe",
  "section" : [
    {
      "title" : "Chief Complaint",
      "code" : {
        "coding" : [
          {
            "system" : "http://example.org/CodeSystem/section-codes",
            "code" : "CHIEF_COMPLAINT",
            "display" : "Chief Complaint"
          }
        ]
      },
      "entry" : [
        {
          "reference" : "Observation/chief-complaint-obs"
        }
      ]
    },
    {
      "title" : "Allergies",
      "code" : {
        "coding" : [
          {
            "system" : "http://example.org/CodeSystem/section-codes",
            "code" : "ALLERGIES_SECTION",
            "display" : "Allergies Section"
          }
        ]
      },
      "entry" : [
        {
          "reference" : "AllergyIntolerance/peanut-allergy"
        }
      ]
    }
  ]
}

```
