# SGHI Service Request CodeSystem - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI Service Request CodeSystem**

## CodeSystem: SGHI Service Request CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/service-request-cs | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHIServiceRequestCS |

 
A custom CodeSystem defining different elements of service requests. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SGHIServiceRequestCategory](ValueSet-service-request-category.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "service-request-cs",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/service-request-cs",
  "version" : "0.1.0",
  "name" : "SGHIServiceRequestCS",
  "title" : "SGHI Service Request CodeSystem",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A custom CodeSystem defining different elements of service requests.",
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "laboratory-procedure",
      "display" : "Laboratory procedure"
    },
    {
      "code" : "imaging",
      "display" : "Imaging"
    },
    {
      "code" : "counselling",
      "display" : "Counselling"
    },
    {
      "code" : "education",
      "display" : "Education"
    },
    {
      "code" : "surgical-procedure",
      "display" : "Surgical procedure"
    },
    {
      "code" : "referral",
      "display" : "Referral"
    }
  ]
}

```
