# SGHI LOINC Code System - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHI LOINC Code System**

## CodeSystem: SGHI LOINC Code System 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/loinc-codesystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHILOINCCodeSystem |

 
A a subset of LOINC codes used across SGHI's environment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "loinc-codesystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/loinc-codesystem",
  "version" : "0.1.0",
  "name" : "SGHILOINCCodeSystem",
  "title" : "SGHI LOINC Code System",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A a subset of LOINC codes used across SGHI's environment.",
  "content" : "fragment",
  "concept" : [
    {
      "code" : "39152-4",
      "display" : "Mammogram",
      "definition" : "LOINC Code For Mammogram"
    },
    {
      "code" : "100884-6",
      "display" : "Biopsy",
      "definition" : "LOINC Code For Biospy"
    },
    {
      "code" : "35954-7",
      "display" : "MRI",
      "definition" : "LOINC Code For MRI"
    },
    {
      "code" : "24629-8",
      "display" : "Chest Ultrasound",
      "definition" : "LOINC Code for Chest Ultrasound"
    },
    {
      "code" : "32422-8",
      "display" : "Breast Examination",
      "definition" : "LOINC Code for Breast Examination"
    },
    {
      "code" : "718-7",
      "display" : "Whole Blood",
      "definition" : "LOINC Code for Whole Blood"
    },
    {
      "code" : "2857-1",
      "display" : "Prostate Cancer",
      "definition" : "LOINC Code For Prostate Cancer"
    },
    {
      "code" : "86662-4",
      "display" : "PapSmear",
      "definition" : "LOINC Code For Pap Smear"
    },
    {
      "code" : "11506-3",
      "display" : "Provider Unspecified Progress Note",
      "definition" : "LOINC Code For Unspecified Progress Note"
    },
    {
      "code" : "81216-4",
      "display" : "Progress Note Code",
      "definition" : "LOINC Code For Progress Note"
    },
    {
      "code" : "51847-2",
      "display" : "Assessment Plan Code",
      "definition" : "LOINC Code for Assessment Plan"
    },
    {
      "code" : "10164-2",
      "display" : "History Of Presenting Illness",
      "definition" : "LOINC Code For History Of Present Illness"
    },
    {
      "code" : "29762-2",
      "display" : "Social History",
      "definition" : "LOINC Code For Social History"
    },
    {
      "code" : "10157-6",
      "display" : "Family History",
      "definition" : "LOINC Code For Family History"
    },
    {
      "code" : "29545-1",
      "display" : "Examination",
      "definition" : "LOINC Code For Examination"
    },
    {
      "code" : "18776-5",
      "display" : "Plan Of Care",
      "definition" : "LOINC Code For Plan Of Care"
    }
  ]
}

```
