# SGHIPersonIdentifierCodeSystem - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHIPersonIdentifierCodeSystem**

## CodeSystem: SGHIPersonIdentifierCodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIPersonIdentifierCodeSystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHIPersonIdentifierCodeSystem |

 
A code system different identifiers used to identify an animal, patient, practitioner or any other live actior in the healthcare context 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SGHIPersonIdentifierTypes](ValueSet-patient-identifier-types.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SGHIPersonIdentifierCodeSystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIPersonIdentifierCodeSystem",
  "version" : "0.1.0",
  "name" : "SGHIPersonIdentifierCodeSystem",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A code system different identifiers used to identify an animal, patient, practitioner or any other live actior in the healthcare context",
  "content" : "complete",
  "count" : 15,
  "concept" : [
    {
      "code" : "national-id",
      "display" : "National ID",
      "definition" : "A unique national identifier assigned by the National Registration Bureau (NRB) under the Ministry of Interior and National Administration."
    },
    {
      "code" : "passport-number",
      "display" : "Passport Number",
      "definition" : "A unique identifier assigned by the Directorate of Immigration Services under the Ministry of Interior and National Administration."
    },
    {
      "code" : "military-id",
      "display" : "Military ID",
      "definition" : "A unique identifier assigned by the Kenya Defence Forces (KDF) for military personnel."
    },
    {
      "code" : "alien-id",
      "display" : "Alien ID",
      "definition" : "A unique identifier assigned by the Directorate of Immigration Services to foreign nationals residing in Kenya."
    },
    {
      "code" : "patient-number",
      "display" : "Patient Number",
      "definition" : "A unique identifier assigned by Slade360 Advantage for internal patient tracking."
    },
    {
      "code" : "payer-member-number",
      "display" : "Payer Member Number",
      "definition" : "A unique identifier assigned by insurance providers, including private insurers and Slade360."
    },
    {
      "code" : "smart-member-number",
      "display" : "Smart Member Number",
      "definition" : "A unique health identifier assigned by Slade360."
    },
    {
      "code" : "drchrono-id",
      "display" : "Dr Chrono Chart ID",
      "definition" : "A unique identifier assigned by the Dr. Chrono healthcare platform for patient records."
    },
    {
      "code" : "erp-customer-id",
      "display" : "ERP Customer ID",
      "definition" : "A unique patient identifier assigned by Slade360 ERP system."
    },
    {
      "code" : "ccc-number",
      "display" : "Comprehensive Care Clinic Number",
      "definition" : "A unique identifier assigned by HIV/AIDS treatment programs."
    },
    {
      "code" : "refugee-id",
      "display" : "Refugee ID",
      "definition" : "A unique identifier assigned by the Refugee Affairs Secretariat (RAS) under the Ministry of Interior, in collaboration with UNHCR."
    },
    {
      "code" : "birth-certificate",
      "display" : "Birth Certificate Number",
      "definition" : "A unique identifier assigned by the Civil Registration Department under the Ministry of Interior and National Administration."
    },
    {
      "code" : "mandate-number",
      "display" : "Mandate Number",
      "definition" : "A regulatory or legal identifier assigned by relevant government agencies."
    },
    {
      "code" : "client-registry-number",
      "display" : "Client Registry Number",
      "definition" : "A unique identifier used for internal patient tracking within a Client Registry system."
    },
    {
      "code" : "slade-health-id",
      "display" : "Slade Health ID",
      "definition" : "A unique health identifier assigned by Slade360 Health CRM for patient records."
    }
  ]
}

```
