# SGHIOrganisationIdentifierCodeSystem - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHIOrganisationIdentifierCodeSystem**

## CodeSystem: SGHIOrganisationIdentifierCodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIOrganisationIdentifierCodeSystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHIOrganisationIdentifierCodeSystem |

 
A single code system enumerating the identifier types used identify organisations across SIL's environment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SGHIOrganizationIdentifierTypes](ValueSet-organization-identifier-types.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SGHIOrganisationIdentifierCodeSystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIOrganisationIdentifierCodeSystem",
  "version" : "0.1.0",
  "name" : "SGHIOrganisationIdentifierCodeSystem",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A single code system enumerating the identifier types used identify organisations across SIL's environment.",
  "content" : "complete",
  "count" : 7,
  "concept" : [
    {
      "code" : "mfl-code",
      "display" : "Master Facility List Code",
      "definition" : "Official identifier assigned by the Kenya Master Facility List (MFL) for healthcare facilities and organizations within Kenya's health system"
    },
    {
      "code" : "sha-slade-code",
      "display" : "SHA Slade Code",
      "definition" : "Unique identifier assigned by the Social Health Authority (SHA) in collaboration with Slade 360 platform for healthcare provider identification and claims processing"
    },
    {
      "code" : "fid-code",
      "display" : "Facility ID Code",
      "definition" : "Generic facility identification code used for internal healthcare facility tracking and administrative purposes"
    },
    {
      "code" : "fr-code",
      "display" : "Facility Registry Code",
      "definition" : "Identifier assigned by the national or regional Facility Registry system for official healthcare facility registration and cataloging"
    },
    {
      "code" : "kmpdc-registration-number",
      "display" : "KMPDC Registration Number",
      "definition" : "Registration number issued by the Kenya Medical Practitioners and Dentists Council (KMPDC) for licensed medical practitioners and dentists"
    },
    {
      "code" : "slade-code",
      "display" : "Slade360 Code",
      "definition" : "Unique identifier assigned by the Slade 360 healthcare information platform for healthcare organizations and providers within their network"
    },
    {
      "code" : "default-id",
      "display" : "Default System Identifier",
      "definition" : "A unique UUID identifier assigned by the system by default"
    }
  ]
}

```
