# SGHIDefaultIdentifierCodeSystem - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHIDefaultIdentifierCodeSystem**

## CodeSystem: SGHIDefaultIdentifierCodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIDefaultIdentifierCodeSystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHIDefaultIdentifierCodeSystem |

 
A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SGHIDefaultIdentifierTypes](ValueSet-default-identifier-types.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SGHIDefaultIdentifierCodeSystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIDefaultIdentifierCodeSystem",
  "version" : "0.1.0",
  "name" : "SGHIDefaultIdentifierCodeSystem",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem.",
  "content" : "complete",
  "count" : 1,
  "concept" : [
    {
      "code" : "default-id",
      "display" : "Default Resource Identifier",
      "definition" : "A unique UUID identifier assigned by the system by default."
    }
  ]
}

```
