# SGHIConditionSeverityCodeSystem - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SGHIConditionSeverityCodeSystem**

## CodeSystem: SGHIConditionSeverityCodeSystem 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIConditionSeverityCodeSystem | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:SGHIConditionSeverityCodeSystem |

 
A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [SGHIConditionSeverity](ValueSet-condition-severity.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "SGHIConditionSeverityCodeSystem",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/SGHIConditionSeverityCodeSystem",
  "version" : "0.1.0",
  "name" : "SGHIConditionSeverityCodeSystem",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "A single code system enumerating severity levels for clinical conditions within the SGHI ecosystem.",
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "severe",
      "display" : "Severe",
      "definition" : "Indicates a life-threatening or highly serious clinical condition requiring urgent or intensive medical intervention."
    },
    {
      "code" : "mild",
      "display" : "Mild",
      "definition" : "Indicates a low-severity clinical condition with minimal symptoms and routine clinical management."
    },
    {
      "code" : "moderate",
      "display" : "Moderate",
      "definition" : "Indicates a clinical condition of intermediate severity requiring medical attention but not immediately life-threatening."
    }
  ]
}

```
