# KNC4Drugs - SGHI FHIR Profile Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **KNC4Drugs**

## CodeSystem: KNC4Drugs 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.slade360.co.ke/fhir/CodeSystem/KNC4Drugs | *Version*:0.1.0 |
| Active as of 2026-01-09 | *Computable Name*:KNC4Drugs |
| *Other Identifiers:*Accession ID: /orgs/SIL/CodeSystem/KNC4Drugs/ | |

 
First Version 

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "KNC4Drugs",
  "meta" : {
    "lastUpdated" : "2025-02-20T13:09:26.142316Z"
  },
  "language" : "en",
  "url" : "https://fhir.slade360.co.ke/fhir/CodeSystem/KNC4Drugs",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/v2/0203",
            "code" : "ACSN",
            "display" : "Accession ID"
          }
        ],
        "text" : "Accession ID"
      },
      "system" : "https://ocl-testing-api.savannahghi.org",
      "value" : "/orgs/SIL/CodeSystem/KNC4Drugs/"
    }
  ],
  "version" : "0.1.0",
  "name" : "KNC4Drugs",
  "title" : "KNC4Drugs",
  "status" : "active",
  "date" : "2026-01-09T12:13:36+00:00",
  "publisher" : "Kathurima Kimathi",
  "contact" : [
    {
      "name" : "Kathurima Kimathi",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.linkedin.com/in/kathurima-kimathi/"
        },
        {
          "system" : "email",
          "value" : "kathurimakimathi415@gmail.com"
        }
      ]
    },
    {
      "name" : "Oscar John",
      "telecom" : [
        {
          "system" : "email",
          "value" : "oscarjohnotieno@gmail.com",
          "use" : "work"
        }
      ]
    },
    {
      "name" : "Kennedy Omondi",
      "telecom" : [
        {
          "system" : "email",
          "value" : "kennankole@gmail.com",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "First Version",
  "content" : "fragment",
  "count" : 201657,
  "property" : [
    {
      "code" : "conceptclass",
      "uri" : "https://ocl-testing-api.savannahghi.org/orgs/OCL/sources/Classes/concepts",
      "description" : "Standard list of concept classes.",
      "type" : "string"
    },
    {
      "code" : "datatype",
      "uri" : "https://ocl-testing-api.savannahghi.org/orgs/OCL/sources/Datatypes/concepts",
      "description" : "Standard list of concept datatypes.",
      "type" : "string"
    },
    {
      "code" : "inactive",
      "uri" : "http://hl7.org/fhir/concept-properties",
      "description" : "True if the concept is not considered active.",
      "type" : "Coding"
    }
  ],
  "concept" : [
    {
      "code" : "ROA-00000011",
      "display" : "Intestinal",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intestinal"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000029",
      "display" : "Intrasternal",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intrasternal"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000020",
      "display" : "Intraventricular cardiac",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intraventricular cardiac"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000018",
      "display" : "Submucosal rectal",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Submucosal rectal"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000019",
      "display" : "Intracerebroventricular",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intracerebroventricular"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000016",
      "display" : "Oromucosal",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Oromucosal"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000012",
      "display" : "Subretinal",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Subretinal"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000014",
      "display" : "Intracameral",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intracameral"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000017",
      "display" : "Regional perfusion",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Regional perfusion"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000027",
      "display" : "Obsolete-Oromucosal other",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Obsolete-Oromucosal other"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000030",
      "display" : "Intracervical",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intracervical"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000024",
      "display" : "Obsolete-Intraventricular",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Obsolete-Intraventricular"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000025",
      "display" : "Route of administration not applicable",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Route of administration not applicable"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000022",
      "display" : "Haemofiltration",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Haemofiltration"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000031",
      "display" : "Intraarticular",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intraarticular"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000026",
      "display" : "Inhalation",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Inhalation"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000021",
      "display" : "Intraosseous",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intraosseous"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000013",
      "display" : "Intratumoral",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Intratumoral"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000054",
      "display" : "Subconjunctival",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Subconjunctival"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000015",
      "display" : "Epilesional",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Epilesional"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000055",
      "display" : "Subarachnoid",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Subarachnoid"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000057",
      "display" : "Retrobulbar",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Retrobulbar"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000060",
      "display" : "Periodontal",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Periodontal"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000058",
      "display" : "Respiratory (Inhalation)",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Respiratory (Inhalation)"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    },
    {
      "code" : "ROA-00000061",
      "display" : "Perineural",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "Fully Specified"
          },
          "value" : "Perineural"
        }
      ],
      "property" : [
        {
          "code" : "conceptclass"
        },
        {
          "code" : "datatype"
        }
      ]
    }
  ]
}

```
