# Rwanda Patient Profile - Your IG Title v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Rwanda Patient Profile**

## Resource Profile: Rwanda Patient Profile 

| | |
| :--- | :--- |
| *Official URL*:http://your.canonical.url/fhir/StructureDefinition/rw-patient | *Version*:1.0.0 |
| Active as of 2025-10-17 | *Computable Name*:RWPatient |

 
This is the Patient profile customized for Rwanda. 

**Usages:**

* Examples for this Profile: [Patient/MyFirstRwandaPatientProfile](Patient-MyFirstRwandaPatientProfile.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/your.package.id|current/StructureDefinition/rw-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-rw-patient.csv), [Excel](StructureDefinition-rw-patient.xlsx), [Schematron](StructureDefinition-rw-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "rw-patient",
  "url" : "http://your.canonical.url/fhir/StructureDefinition/rw-patient",
  "version" : "1.0.0",
  "name" : "RWPatient",
  "title" : "Rwanda Patient Profile",
  "status" : "active",
  "date" : "2025-10-17T08:59:51+00:00",
  "publisher" : "Your Organization",
  "contact" : [
    {
      "name" : "Your Organization",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://organization.url/"
        },
        {
          "system" : "email",
          "value" : "info@someorg.org"
        }
      ]
    },
    {
      "name" : "Richard Langford",
      "telecom" : [
        {
          "system" : "email",
          "value" : "richard.langford@jembi.org",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This is the Patient profile customized for Rwanda.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "description" : "Slice based on the type of identifier.",
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.identifier:PassPortID",
        "path" : "Patient.identifier",
        "sliceName" : "PassPortID",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:PassPortID.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "patternUri" : "http://kenya.training.org/fhir/identifier/PassPortID"
      },
      {
        "id" : "Patient.identifier:PassPortID.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.identifier:BirthCert",
        "path" : "Patient.identifier",
        "sliceName" : "BirthCert",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Patient.identifier:BirthCert.system",
        "path" : "Patient.identifier.system",
        "min" : 1,
        "patternUri" : "http://kenya.training.org/fhir/identifier/BirthCert"
      },
      {
        "id" : "Patient.identifier:BirthCert.value",
        "path" : "Patient.identifier.value",
        "min" : 1
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.gender",
        "path" : "Patient.gender",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://your.canonical.url/fhir/ValueSet/Gender-vs"
        }
      },
      {
        "id" : "Patient.birthDate",
        "path" : "Patient.birthDate",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.address",
        "path" : "Patient.address",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.maritalStatus",
        "path" : "Patient.maritalStatus",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
