# Artifacts Summary - Your IG Title v1.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Rwanda Patient Profile](StructureDefinition-rw-patient.md) | This is the Patient profile customized for Rwanda. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [EducationLevelExt](StructureDefinition-EducationLevelExt.md) | This is an extension for Education Level |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Education Level ValueSet](ValueSet-educationLevel-vs.md) | ValueSet containing codeSystem for Education Level |
| [Gender ValueSet](ValueSet-Gender-vs.md) | ValueSet for Gender |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Code System for Gender](CodeSystem-gender-cs.md) | A code system for gender |
| [Education Level](CodeSystem-education-level.md) | Code system for different levels of education |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Rwanda Patient Profile](Patient-MyFirstRwandaPatientProfile.md) | Example instance for Rwanda Patient Profile |

