# Education Level ValueSet - Your IG Title v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Education Level ValueSet**

## ValueSet: Education Level ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://your.canonical.url/fhir/ValueSet/educationLevel-vs | *Version*:1.0.0 |
| Active as of 2025-10-17 | *Computable Name*:EducationVS |

 
ValueSet containing codeSystem for Education Level 

 **References** 

* [EducationLevelExt](StructureDefinition-EducationLevelExt.md)

### Logical Definition (CLD)

* Include all codes defined in [`http://your.canonical.url/fhir/CodeSystem/education-level`](CodeSystem-education-level.md)version 📦1.0.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "educationLevel-vs",
  "url" : "http://your.canonical.url/fhir/ValueSet/educationLevel-vs",
  "version" : "1.0.0",
  "name" : "EducationVS",
  "title" : "Education Level ValueSet",
  "status" : "active",
  "date" : "2025-10-17T08:59:51+00:00",
  "publisher" : "Your Organization",
  "contact" : [
    {
      "name" : "Your Organization",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://organization.url/"
        },
        {
          "system" : "email",
          "value" : "info@someorg.org"
        }
      ]
    },
    {
      "name" : "Richard Langford",
      "telecom" : [
        {
          "system" : "email",
          "value" : "richard.langford@jembi.org",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "ValueSet containing codeSystem for Education Level",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://your.canonical.url/fhir/CodeSystem/education-level"
      }
    ]
  }
}

```
