# Source and Additional Information - HL7 Europe Medication Prescription and Dispense v0.1.0-ci-build

* [**Table of Contents**](toc.md)
* **Source and Additional Information**

## Source and Additional Information

### eP/eD specifications

* [Xt-EHR logical models](https://build.fhir.org/ig/Xt-EHR/xt-ehr-common/useCasePrescription.html)
* [eHealth Network Guideline on ePrescription and eDispensation of Authorised Medicinal Products](https://health.ec.europa.eu/document/download/b744f30b-a05e-4b9c-9630-ad96ebd0b2f0_en?filename=ehn_guidelines_eprescriptions_en.pdf)
* [IHE Medication Prescription and Dispense profile](https://profiles.ihe.net/PHARM/MPD/)
* ISO/DIS 17523 "Health informatics - Requirements for electronic prescriptions"
* MyHealth@EU [requirements catalogue, requires EU login](https://webgate.ec.europa.eu/fpfis/wikis/display/EHDSI/1.+MyHealth@EU+Requirements+Catalogue) and [CDA specification](https://art-decor.ehdsi.eu/publication/)

### Medication and terminology specifications

* [SNOMED CT Medicinal Product Model Specification](https://confluence.ihtsdotools.org/display/DOCMPM)
* [The Relationship Between SNOMED CT and IDMP to Facilitate Data Flow](https://confluence.ihtsdotools.org/download/attachments/115870807/IDMP%20and%20SNOMED%20CT%20DIscussion%20Paper_June%202024.pdf)
* [EDQM Standard Terms](https://standardterms.edqm.eu/)
* [European Medicines Agency ISO IDMP implementation guidance](https://www.ema.europa.eu/en/human-regulatory-overview/research-development/data-medicines-iso-idmp-standards-overview/substance-product-organisation-referential-spor-master-data/substance-product-data-management-services), including [FHIR IG](https://www.ema.europa.eu/en/documents/regulatory-procedural-guideline/product-management-services-pms-implementation-international-organization-standardization-iso-standards-identification-medicinal-products-idmp-europe-chapter-2_en.pdf)
* [EMA SPOR](https://spor.ema.europa.eu/sporwi/)
* UNICOM project: [web page](https://unicom-project.eu/), [FHIR IG](https://build.fhir.org/ig/hl7-eu/unicom-ig/), [public deliverables](https://unicom-project.eu/public-deliverables/)
* [Links to national medicines registers](https://www.ema.europa.eu/en/medicines/national-registers-authorised-medicines)

