# Organization 3 - HealthcareService Geriatrie - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - HealthcareService Geriatrie**

## Example HealthcareService: Organization 3 - HealthcareService Geriatrie

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: `https://cp3-test.example.org/services`/4fcf98c7-b198-4d61-8b3e-5ea39e33c405

**active**: true

**providedBy**: [Organization example Care Institution](Organization-3e799075-63a2-4a4c-913d-a91b8198463d.md)

**type**: Brief comprehensive geriatric assessment, comprehensive geriatric assessment, Visual field study

**specialty**: Medisch specialisten, geriatrie

**name**: Geriatrie



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "4fcf98c7-b198-4d61-8b3e-5ea39e33c405",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "https://cp3-test.example.org/services",
      "value" : "4fcf98c7-b198-4d61-8b3e-5ea39e33c405",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "33333333"
        }
      }
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/3e799075-63a2-4a4c-913d-a91b8198463d"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "146521000146103",
          "display" : "Brief comprehensive geriatric assessment"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "107101000146106",
          "display" : "comprehensive geriatric assessment"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "86944008",
          "display" : "Visual field study"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0335",
          "display" : "Medisch specialisten, geriatrie"
        }
      ]
    }
  ],
  "name" : "Geriatrie"
}

```
