# NL GF Data exchange capabilities - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL GF Data exchange capabilities**

## ValueSet: NL GF Data exchange capabilities (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/ValueSet/nl-gf-data-exchange-capabilities-vs | *Version*:0.2.0 |
| Active as of 2025-10-16 | *Computable Name*:NlGfDataExchangeCapabilitiesVS |

 
The data exchange capabilities supported by the NL Generic Functions. 

 **References** 

* [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

### Logical Definition (CLD)

This value set includes codes based on the following rules:

* Import all the codes that are contained in [Endpoint Payload Type](http://hl7.org/fhir/R4/valueset-endpoint-payload-type.html)
* Include all codes defined in [`http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities`](CodeSystem-nl-gf-data-exchange-capabilities.md)version 📦0.2.0

 

### Expansion

No Expansion for this valueset (Unknown Code System)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "nl-gf-data-exchange-capabilities-vs",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/ValueSet/nl-gf-data-exchange-capabilities-vs",
  "version" : "0.2.0",
  "name" : "NlGfDataExchangeCapabilitiesVS",
  "title" : "NL GF Data exchange capabilities",
  "status" : "active",
  "experimental" : true,
  "date" : "2025-10-16T07:33:59+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The data exchange capabilities supported by the NL Generic Functions.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : ["http://hl7.org/fhir/ValueSet/endpoint-payload-type"]
      },
      {
        "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities"
      }
    ]
  }
}

```
