# Credential Catalog - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* **Credential Catalog**

## Credential Catalog

| |
| :--- |
| *Page standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) |

### Credential Catalog

This section describes the various types of verifiable credentials used in the authentication framework. Each credential type represents a specific set of claims about an entity within the healthcare ecosystem.

Credentials defined here use identifiers that are specified by the Generic Function Identification.

#### Profile

Unless specified otherwise, every credential uses the following Verifiable Credential traits:

* **Data model**: [W3C Verifiable Credentials Data Model 1.1](https://www.w3.org/TR/vc-data-model-1.1/)
* **Proof type**: [JWT](https://www.w3.org/TR/vc-data-model-1.1/#json-web-token)
* **Signature algorithm**: `ES256`, `RS256` or `PS256`
* **Revocation method**: [Bitstring Status List v1.0](https://www.w3.org/TR/vc-bitstring-status-list/)
* **Proof of Possession**: presenter is holder: the identifier of the presenter must equal the credential subject identifier.

#### Credentials

| | | |
| :--- | :--- | :--- |
| [HealthcareProviderRoleTypeCredential](credential-HealthcareProviderRoleTypeCredential.md) | Establishes the category or type of healthcare services a provider organization is authorized to offer. | trial use |
| [DeziIDTokenCredential](credential-DeziIDTokenCredential.md) | Wraps a Dezi OIDC ID-Token to assert the identity of a healthcare worker and their employment relationship. | draft |

