# Organization 3- Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3- Organization**

## Example Organization: Organization 3- Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/33333333, `https://cp3-test.example.org/departments`/3e799075-63a2-4a4c-913d-a91b8198463d

**type**: Verplegings- of verzorgingsinstelling

**name**: example Care Institution

**telecom**: [+31301234567](tel:+31301234567), [info@organization3.nl](mailto:info@organization3.nl)

**address**: Smidsstraat 10 Zelhem 7021 AC 

**endpoint**: 

* [Endpoint FHIR R4 Endpoint](Endpoint-ad3-e1.md)
* [Endpoint FHIR STU3 Endpoint](Endpoint-ad3-e2.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "ad3-o1",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "33333333"
    },
    {
      "system" : "https://cp3-test.example.org/departments",
      "value" : "3e799075-63a2-4a4c-913d-a91b8198463d",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "33333333"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "X3",
          "display" : "Verplegings- of verzorgingsinstelling"
        }
      ]
    }
  ],
  "name" : "example Care Institution",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234567",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@organization3.nl",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Smidsstraat 10"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Smidsstraat"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "10"
            }
          ]
        }
      ],
      "city" : "Zelhem",
      "postalCode" : "7021 AC"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/ad3-e1"
    },
    {
      "reference" : "Endpoint/ad3-e2"
    }
  ]
}

```
