# Authenticated Interaction [GFI-005] - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Authentication**](authentication.md)
* **Authenticated Interaction [GFI-005]**

## Authenticated Interaction [GFI-005]

### Scope

The transaction Authenticated Interaction describes a secure and authenticated communication channel between two parties, typically a client representing a holder and a data custodian protected by the verifier. This channel is created on the application layer using a token based authentication mechanism.

This interaction describes how a client can use the access token in an HTTP request to interact with a RESTful API provided by a resource server at the Custodian. To prevent token theft and replay attacks, the client uses the OAuth 2.0 Demonstration of Proof-of-Possession (DPoP) mechanism to bind the access token to a public/private key pair held by the client.

### Actor Roles

| | |
| :--- | :--- |
| Holder | Uses an access token to interact with a resource server at the custodian |
| Custodian | Provides a RESTful API to access and manage data, protected by an access token issued by the verifier |

### Referenced standards

* [OAuth 2.0 Authorization Framework](https://datatracker.ietf.org/doc/html/rfc6749)
* [OAuth 2.0 Demonstration of Proof-of-Possession (DPoP)](https://datatracker.ietf.org/doc/html/rfc9449)

### Messages

1. Create DPoP Proof
1. Authenticated API Request
1. Authenticated API Response

#### Create DPoP Proof

##### Trigger events

* A client needs to access or manage data at a custodian using a RESTful API and has obtained an access token from a verifier.

##### Message semantics

The client creates a DPoP proof JWT as specified in the [OAuth 2.0 Demonstration of Proof-of-Possession (DPoP)](https://datatracker.ietf.org/doc/html/rfc9449) specification. The DPoP proof JWT includes claims such as `htm` (HTTP method), `htu` (HTTP URI), `jti` (JWT ID), and `iat` (issued at time).

##### Example

Below is a non-normative example of a DPoP proof JWT:

Header:

```
{
  "typ": "dpop+jwt",
  "alg": "RS256",
  "jwk": {
    "kty": "RSA",
    "e": "AQAB",
    "n": "0vx7agoebGcQSuuPiLJXZptN9nndrQmbXEps2aiAFbWhM78LhWx4cbbfAAtVT86..."
  }
}

```

Payload:

```
{
  "htm": "GET",
  "htu": "https://custodian.example.com/fhir/Patient/123",
  "jti": "a-123",
  "iat": 1618884473
}

```

#### Authenticated API Request

##### Trigger events

* A client needs to access or manage data at a custodian using a RESTful API and has obtained an access token from a verifier.

##### Message semantics

The client creates a DPoP proof JWT as specified in the [OAuth 2.0 Demonstration of Proof-of-Possession (DPoP)](https://datatracker.ietf.org/doc/html/draft-ietf-oauth-dpop-04) specification. The DPoP proof JWT includes claims such as `htm` (HTTP method), `htu` (HTTP URI), `jti` (JWT ID), and `iat` (issued at time).

The Access Token must be included in the `Authorization` header as a DPoP token, and the DPoP proof JWT must be included in the `DPoP` header of the HTTP request.

##### Example

Below is a non-normative example of an Authenticated API Request:

```
GET /fhir/Patient/123 HTTP/1.1
Host: custodian.example.com
Authorization: DPoP eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9...
DPoP: eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9...

```

#### Authenticated API Response

##### Trigger events

* The custodian processes the authenticated API request and responds with the requested data or an appropriate status

##### Message semantics

The resource server verifies the DPoP proof and the access token included in the request. If the verification is successful and the access token is valid, the custodian processes the request accordingly and responds with the requested data or a status message.

##### Expected Actions

The resource server should store the `jti` claim from the DPoP proof until it expires, to prevent replay attacks.

