# Request Access Token [GFI-004] - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Authentication**](authentication.md)
* **Request Access Token [GFI-004]**

## Request Access Token [GFI-004]

### Scope

The transaction Request Access Token is used by a client to obtain an access token from an authorization server. The client offers credentials from an holder to the authorization server which then verifies the credentials and answers with an access token that can be used to access a protected resource.

In order to proof possession of the credentials, the holder uses its private key to sign the Verifiable Presentation.

This interaction is scoped on the interaction between two computers with not necessarily a human in the loop. Therefore the interaction is a back-channel interaction without a user-agent such as a web browser. For this reason the OAuth 2.0 Extension [RFC 7523](https://datatracker.ietf.org/doc/html/rfc7523) is used to offer the credentials in the form of a JWT assertion directly to the token endpoint without the use of a authorization request.

### Actor Roles

| | |
| :--- | :--- |
| Holder (Client) | Requests an access token from the authorization server by offering verifiable credentials |
| Verifier (Authorization Server) | Verifies the offered credentials and issues an access token |

### Referenced standards

* [OAuth 2.0 Authorization Framework](https://datatracker.ietf.org/doc/html/rfc6749)
* [RFC 7523: JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants](https://datatracker.ietf.org/doc/html/rfc7523)
* [Verifiable Credentials Data Model 1.1](https://www.w3.org/TR/2022/REC-vc-data-model-20220303/)
* [OAuth 2.0 Demonstration of Proof-of-Possession (DPoP)](https://datatracker.ietf.org/doc/html/draft-ietf-oauth-dpop-04)

### Messages

1. Access Token Request
1. Access Token Response

#### Access Token Request

##### Trigger events

* A client needs to obtain an access token from an authorization server.

##### Message semantics

The client requests an access token from the authorization server using the OAuth 2.0 JWT bearer token flow as defined in [RFC 7523](https://datatracker.ietf.org/doc/html/rfc7523).

If an authorization server is shared between multiple (care) organizations (e.g. a multi-tenant setup), the authentication server must have a path parameter or a different endpoint to identify the organization the client is requesting the access token for. The client should not have to know the internal identifier of the organization. The access token must be bound to the requested organization.

If the client wants to bind the access token to a private key, it can include a DPoP header in the request as defined in [OAuth 2.0 Demonstration of Proof-of-Possession (DPoP)](https://datatracker.ietf.org/doc/html/rfc9449).

Verifiable Credentials and Verifiable Presentations must be encoded as JWTs as defined in [Section 6.3.1 of the Verifiable Credentials Data Model 1.1](https://www.w3.org/TR/2022/REC-vc-data-model-20220303/#json-web-token).

###### Request parameters

The request must include the following information:

* `grant_type`: Must be set to `urn:ietf:params:oauth:grant-type:jwt-bearer`
* `assertion`: A JWT assertion in the form of a verifiable presentation containing the verifiable credentials offered by the holder, typically the care organization and/or authenticated user. The JWT must be signed by the holder.
* `client_assertion`: A JWT signed by the client to authenticate itself to the authorization server. The JWT is in the form of a Verifiable Presentation containing a verifiable credentials which contain the identifier of the client and its certifications/affiliations which authorizes the client to request the scopes it is requesting.
* `scope`: (Optional) A space-separated list of scopes that the client is requesting.

###### Assertions

The **assertion** and the **client_assertion** must include the following properties:

* `iss`: The issuer of the JWT. For the `assertion` this is the identifier of the holder. For the `client_assertion` this is the identifier of the client.
* `aud`: The audience of the JWT. This must be the identifier of the authorization server.
* `jti`: A unique identifier for the JWT.
* `nbf`: (Optional) The time before which the JWT must not be accepted for processing.
* `iat`: The time at which the JWT was issued.
* `exp`: The expiration time on or after which the JWT must not be accepted for processing.
* `vp`: The verifiable presentation containing the verifiable credentials. The `vp` claim must conform to the [Verifiable Credentials Data Model 1.1](https://www.w3.org/TR/2022/REC-vc-data-model-20220303/) specification.

The request must be sent as a HTTP POST request to the authorization server's token endpoint with the `Content-Type` header set to `application/x-www-form-urlencoded`.

##### Example

Below is a non-normative example of an Access Token Request:

```
POST /oauth/{tenant-id}/token HTTP/1.1
Host: example.com
Content-Type: application/x-www-form-urlencoded
grant_type=urn:ietf:params:oauth:grant-type:jwt-bearer&
assertion=eyJhbGciOiJFUzI1NiIsInR5c&
client_assertion_type=urn:ietf:params:oauth:client-assertion-type:jwt-bearer&
client_assertion=eyJhbGciOiJFUzI1NiIsInR5c&
scope=use-case1 use-case2

```

Below is a non-normative example of a JWT assertion in the form of a verifiable presentation:

```
{
  "iss": "did:web:example.com",
  "jti": "urn:uuid:3978344f-8596-4c3a-a978-8fcaba3903c5",
  "aud": "https://auth.example.com/oauth/token",
  "nbf": 1541493724,
  "iat": 1541493724,
  "exp": 1573029723,
  "vp": {
    "@context": [
      "https://www.w3.org/2018/credentials/v1",
      "https://www.w3.org/2018/credentials/examples/v1"
    ],
    "type": ["VerifiablePresentation"],
    "verifiableCredential": ["... verifiable credential ..."]
  }
}

```

#### Access Token Response

##### Trigger events

* The authorization server responds to the access token request with an access token that the client can use to access a protected resource.

##### Message semantics

The verifier responds with a HTTP 200 OK response containing the access token in the body of the response.

The access token is opaque to the client and the format is determined by the authorization server.

If the client provided a DPoP header in the access token request, the authorization server must issue a DPoP-bound access token.

The response must include the following information:

* `access_token`: The access token issued by the authorization server.
* `token_type`: The type of the token issued. Must be set to `Bearer` or `DPoP`.
* `expires_in`: (Optional) The lifetime in seconds of the access token.
* `scope`: (Optional) The scope of the access token.

##### Example

Below is a non-normative example of an Access Token Response:

```
HTTP/1.1 200 OK
Content-Type: application/json
{
    "access_token": "SlAV32hkKG",
    "token_type": "Bearer",
    "expires_in": 3600,
    "scope": "use-case1 use-case2"
}

```

##### Expected Actions

* The client extracts the access token from the response and uses it to access the protected resource.

