# NL Generic Functions HealthcareService Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions HealthcareService Profile**

## Resource Profile: NL Generic Functions HealthcareService Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice | *Version*:0.3.0 |
| Draft as of 2026-02-04 | *Computable Name*:NlGfHealthcareService |

 
The technical details of a healthcare service that can be used in referrals, requests and orders 

**Usages:**

* Refer to this Profile: [HealthcareService for Task in STU3](StructureDefinition-task-stu3-healthcareservice.md)
* Examples for this Profile: [Urologie](HealthcareService-08013141-16b2-42a0-8c9a-af57cee5511b.md), [Geriatrie](HealthcareService-120325af-083c-40ee-b16e-01230fe65655.md), [Geriatrie](HealthcareService-4fcf98c7-b198-4d61-8b3e-5ea39e33c405.md), [Polikliniek 't Vaatje](HealthcareService-5cb05355-474b-4d30-8b0e-a9ca574b8274.md)... Show 12 more, [Orthopedie](HealthcareService-9d47ca45-4166-4531-a23d-ef5fa613ece4.md), [Polikliniek 't Vaatje](HealthcareService-ad2-hs1.md), [Neurochirurgie](HealthcareService-ad2-hs2.md), [Orthopedie](HealthcareService-ad2-hs3.md), [Interne Geneeskunde](HealthcareService-ad2-hs4.md), [Geriatrie](HealthcareService-ad2-hs5.md), [Urologie](HealthcareService-ad2-hs6.md), [Geriatrie](HealthcareService-ad3-hs1.md), [Verpleging](HealthcareService-ad3-hs2.md), [Verpleging](HealthcareService-b48826dc-2d58-479a-bfd3-80b7a9d69757.md), [Neurochirurgie](HealthcareService-c79125e5-739f-4238-959c-cd5872518c1f.md) and [Interne Geneeskunde](HealthcareService-f6a508bd-9455-4afa-aad0-baec0833602d.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md), [Query Directory for Query Client for only Read operations](CapabilityStatement-nl-gf-query-directory-query-client-reads.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-healthcareservice)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-healthcareservice.csv), [Excel](StructureDefinition-nl-gf-healthcareservice.xlsx), [Schematron](StructureDefinition-nl-gf-healthcareservice.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-healthcareservice",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice",
  "version" : "0.3.0",
  "name" : "NlGfHealthcareService",
  "title" : "NL Generic Functions HealthcareService Profile",
  "status" : "draft",
  "date" : "2026-02-04T10:18:32+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The technical details of a healthcare service that can be used in referrals, requests and orders",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "HealthcareService",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/HealthcareService",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "HealthcareService",
        "path" : "HealthcareService"
      },
      {
        "id" : "HealthcareService.implicitRules",
        "path" : "HealthcareService.implicitRules",
        "max" : "0"
      },
      {
        "id" : "HealthcareService.modifierExtension",
        "path" : "HealthcareService.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "HealthcareService.identifier",
        "path" : "HealthcareService.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "HealthcareService.identifier:AssignedId",
        "path" : "HealthcareService.identifier",
        "sliceName" : "AssignedId",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.system",
        "path" : "HealthcareService.identifier.system",
        "min" : 1
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.value",
        "path" : "HealthcareService.identifier.value",
        "min" : 1
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner",
        "path" : "HealthcareService.identifier.assigner",
        "min" : 1
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier",
        "path" : "HealthcareService.identifier.assigner.identifier",
        "min" : 1
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier.type",
        "path" : "HealthcareService.identifier.assigner.identifier.type",
        "min" : 1
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier.type.coding",
        "path" : "HealthcareService.identifier.assigner.identifier.type.coding",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier.type.coding.system",
        "path" : "HealthcareService.identifier.assigner.identifier.type.coding.system",
        "patternUri" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type"
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier.type.coding.code",
        "path" : "HealthcareService.identifier.assigner.identifier.type.coding.code",
        "patternCode" : "author"
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier.system",
        "path" : "HealthcareService.identifier.assigner.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/ura"
      },
      {
        "id" : "HealthcareService.identifier:AssignedId.assigner.identifier.value",
        "path" : "HealthcareService.identifier.assigner.identifier.value",
        "min" : 1
      },
      {
        "id" : "HealthcareService.providedBy",
        "path" : "HealthcareService.providedBy",
        "min" : 1
      },
      {
        "id" : "HealthcareService.type",
        "path" : "HealthcareService.type",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://nuts-foundation.github.io/nl-generic-functions-ig/ValueSet/nl-gf-wlz-zorgprofielen-vs"
        }
      },
      {
        "id" : "HealthcareService.type.extension:supportedActivityDefinitions",
        "path" : "HealthcareService.type.extension",
        "sliceName" : "supportedActivityDefinitions",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/supported-activity-definitions"
            ]
          }
        ]
      },
      {
        "id" : "HealthcareService.specialty",
        "path" : "HealthcareService.specialty",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://decor.nictiz.nl/fhir/ValueSet/2.16.840.1.113883.2.4.3.11.60.121.11.22--20200901000000"
        }
      },
      {
        "id" : "HealthcareService.name",
        "path" : "HealthcareService.name",
        "min" : 1
      }
    ]
  }
}

```
