# Administration Directory for Update Client - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Administration Directory for Update Client**

## CapabilityStatement: Administration Directory for Update Client 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client | *Version*:0.2.0 |
| Active as of 2025-08-28 | *Computable Name*: |

 
Dutch profile of the CapabilityStatement for Administration Directory Actor that should be able to work with an Update Client. 

 [Raw OpenAPI-Swagger Definition file](nl-gf-admin-directory-update-client.openapi.json) | [Download](nl-gf-admin-directory-update-client.openapi.json) 

## Administration Directory for Update Client

* Implementation Guide Version: 0.2.0 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2025-08-28 
* Published by: Stichting Nuts 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

Dutch profile of the IHE ITI mCSD ITI-91 endpoint

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Organization](#Organization1-1) | Supported Profiles  [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md) |  | **Y** |  |  | **Y** | _since |  |  |  |
| [Location](#Location1-2) | Supported Profiles  [NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md) |  | **Y** |  |  | **Y** | _since |  |  |  |
| [Practitioner](#Practitioner1-3) | Supported Profiles  [NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md) |  | **Y** |  |  | **Y** | _since |  |  |  |
| [PractitionerRole](#PractitionerRole1-4) | Supported Profiles  [NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md) |  | **Y** |  |  | **Y** | _since |  |  |  |
| [HealthcareService](#HealthcareService1-5) | Supported Profiles  [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md) |  | **Y** |  |  | **Y** | _since |  |  |  |
| [Endpoint](#Endpoint1-6) | Supported Profiles  [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md) |  | **Y** |  |  | **Y** | _since |  |  |  |
| [OrganizationAffiliation](#OrganizationAffiliation1-7) | Supported Profiles  [NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md) |  | **Y** |  |  | **Y** | _since |  |  |  |

-------

#### Resource Conformance: MAY Organization

Core FHIR Resource

[Organization](http://hl7.org/fhir/R4/organization.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

Documentation
> 

.


Search Parameters


 

#### Resource Conformance: MAY Location

Core FHIR Resource

[Location](http://hl7.org/fhir/R4/location.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions Location Profile](StructureDefinition-nl-gf-location.md)

Documentation
> 

.


Search Parameters


 

#### Resource Conformance: MAY Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions Practitioner Profile](StructureDefinition-nl-gf-practitioner.md)

Documentation
> 

.


Search Parameters


 

#### Resource Conformance: MAY PractitionerRole

Core FHIR Resource

[PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions PractitionerRole Profile](StructureDefinition-nl-gf-practitionerrole.md)

Documentation
> 

.


Search Parameters


 

#### Resource Conformance: MAY HealthcareService

Core FHIR Resource

[HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

Documentation
> 

.


Search Parameters


 

#### Resource Conformance: MAY Endpoint

Core FHIR Resource

[Endpoint](http://hl7.org/fhir/R4/endpoint.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

Documentation
> 

.


Search Parameters


 

#### Resource Conformance: MAY OrganizationAffiliation

Core FHIR Resource

[OrganizationAffiliation](http://hl7.org/fhir/R4/organizationaffiliation.html)

Reference Policy

Interaction summary

* **SHALL** support `history-type`, `search-type`.

Supported Profiles
[NL Generic Functions OrganizationAffiliation Profile](StructureDefinition-nl-gf-organizationaffiliation.md)

Documentation
> 

.


Search Parameters


 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "nl-gf-admin-directory-update-client",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
  "version" : "0.2.0",
  "title" : "Administration Directory for Update Client",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-08-28",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "Dutch profile of the CapabilityStatement for Administration Directory Actor that should be able to work with an Update Client.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["application/fhir+xml", "application/fhir+json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "Dutch profile of the IHE ITI mCSD ITI-91 endpoint",
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Organization",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Location",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-location"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Practitioner",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitioner"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "PractitionerRole",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "HealthcareService",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Endpoint",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "OrganizationAffiliation",
          "supportedProfile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organizationaffiliation"
          ],
          "documentation" : ".",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "history-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "name" : "_since",
              "type" : "date"
            }
          ]
        }
      ]
    }
  ]
}

```
