# Organization 3 - HealthcareService Verpleging - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 3 - HealthcareService Verpleging**

## Example HealthcareService: Organization 3 - HealthcareService Verpleging

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**active**: true

**providedBy**: [Organization Nursing department at Organization 3](Organization-631cf10e-42d6-4165-9907-11e2333d4a85.md)

**type**: Patient transfer to skilled nursing facility for level 1 care, Patient transfer to skilled nursing facility for level 2 care, Patient transfer to skilled nursing facility for level 3 care

**specialty**: Verpleegkundige

**name**: Verpleging



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "b48826dc-2d58-479a-bfd3-80b7a9d69757",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/631cf10e-42d6-4165-9907-11e2333d4a85"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "23044009",
          "display" : "Patient transfer to skilled nursing facility for level 1 care"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "58413007",
          "display" : "Patient transfer to skilled nursing facility for level 2 care"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "43495009",
          "display" : "Patient transfer to skilled nursing facility for level 3 care"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0100",
          "display" : "Verpleegkundige"
        }
      ]
    }
  ],
  "name" : "Verpleging"
}

```
