# NL Generic Functions PractitionerRole Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions PractitionerRole Profile**

## Resource Profile: NL Generic Functions PractitionerRole Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole | *Version*:0.2.0 |
| Draft as of 2025-11-14 | *Computable Name*:NlGfPractitionerRole |

 
The details of a healthcare practitioner's role within an organization. 

**Usages:**

* Examples for this Profile: [PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md), [PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de](PractitionerRole-d60525bd-5caf-4437-8f4b-4156300a27de.md) and [PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba](PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.md)
* CapabilityStatements using this Profile: [Administration Directory for Administration Client](CapabilityStatement-nl-gf-admin-directory-admin-client.md), [Administration Directory for Update Client](CapabilityStatement-nl-gf-admin-directory-update-client.md) and [Query Directory for Query Client](CapabilityStatement-nl-gf-query-directory-query-client.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-practitionerrole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-practitionerrole.csv), [Excel](StructureDefinition-nl-gf-practitionerrole.xlsx), [Schematron](StructureDefinition-nl-gf-practitionerrole.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-practitionerrole",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-practitionerrole",
  "version" : "0.2.0",
  "name" : "NlGfPractitionerRole",
  "title" : "NL Generic Functions PractitionerRole Profile",
  "status" : "draft",
  "date" : "2025-11-14T17:01:59+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "The details of a healthcare practitioner's role within an organization.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "zib-healthprofessional-v3.5-2020EN",
      "uri" : "https://zibs.nl/wiki/HealthProfessional-v3.5(2020EN)",
      "name" : "zib HealthProfessional-v3.5(2020EN)"
    },
    {
      "identity" : "zib-contactinformation-v1.2-2020EN",
      "uri" : "https://zibs.nl/wiki/ContactInformation-v1.2(2020EN)",
      "name" : "zib ContactInformation-v1.2(2020EN)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://nictiz.nl/fhir/StructureDefinition/nl-core-HealthProfessional-PractitionerRole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.implicitRules",
        "path" : "PractitionerRole.implicitRules",
        "max" : "0"
      },
      {
        "id" : "PractitionerRole.modifierExtension",
        "path" : "PractitionerRole.modifierExtension",
        "max" : "0"
      },
      {
        "id" : "PractitionerRole.identifier",
        "path" : "PractitionerRole.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "PractitionerRole.identifier:fhirUrl",
        "path" : "PractitionerRole.identifier",
        "sliceName" : "fhirUrl",
        "min" : 1,
        "max" : "1",
        "patternIdentifier" : {
          "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir"
        }
      },
      {
        "id" : "PractitionerRole.practitioner",
        "path" : "PractitionerRole.practitioner",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.organization",
        "path" : "PractitionerRole.organization",
        "min" : 1
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "min" : 1
      }
    ]
  }
}

```
