# fhir-resource-url - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **fhir-resource-url**

## NamingSystem: fhir-resource-url 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/NamingSystem/fhir-resource-url | *Version*:0.2.0 |
| Active as of 2025-11-05 | *Computable Name*:FHIR resource URL |

 
This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. 
Only authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. 
The custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource. 

### Summary

| | |
| :--- | :--- |
| Defining URL | http://nuts-foundation.github.io/nl-generic-functions-ig/NamingSystem/fhir-resource-url |
| Version | 0.2.0 |
| Name | FHIR resource URL |
| Status | active |
| Definition | This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature.Only authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs.The custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource. |
| Publisher | Stichting Nuts |

### Identifiers

* **Type**: URI
  * **Value**: http://fhir.nl/fhir/NamingSystem/url/fhir
  * **Preferred**: true
  * **Comment**: The client system may use the Accept header to request a specific FHIR version, e.g. `Accept: application/fhir+json; fhirVersion=4.0`. See ['Managing Multiple FHIR Versions'](http://hl7.org/fhir/R4/versioning.html#mt-version) for more information. However, a specific FHIR version may not be supported for the intended +10 years, a server MAY ignore this header. If no version is specified, the server returns the default version.



## Resource Content

```json
{
  "resourceType" : "NamingSystem",
  "id" : "fhir-resource-url",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.url",
      "valueUri" : "http://nuts-foundation.github.io/nl-generic-functions-ig/NamingSystem/fhir-resource-url"
    },
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-NamingSystem.version",
      "valueString" : "0.2.0"
    }
  ],
  "name" : "FHIR resource URL",
  "status" : "active",
  "kind" : "identifier",
  "date" : "2025-11-05T00:00:00-00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "uniqueId" : [
    {
      "type" : "uri",
      "value" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
      "preferred" : true,
      "comment" : "The client system may use the Accept header to request a specific FHIR version, e.g. `Accept: application/fhir+json; fhirVersion=4.0`. See ['Managing Multiple FHIR Versions'](http://hl7.org/fhir/R4/versioning.html#mt-version) for more information. \r\nHowever, a specific FHIR version may not be supported for the intended +10 years, a server MAY ignore this header. \r\nIf no version is specified, the server returns the default version."
    }
  ]
}

```
