# Organization 2 - HealthcareService Urologie - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - HealthcareService Urologie**

## Example HealthcareService: Organization 2 - HealthcareService Urologie

Profile: [NL Generic Functions HealthcareService Profile](StructureDefinition-nl-gf-healthcareservice.md)

**identifier**: [FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b

**active**: true

**providedBy**: [Organization example Hospital](Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.md)

**type**: Consultation

**specialty**: Medisch specialisten, urologie, Uroloog

**name**: Urologie



## Resource Content

```json
{
  "resourceType" : "HealthcareService",
  "id" : "08013141-16b2-42a0-8c9a-af57cee5511b",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-healthcareservice"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
      "value" : "https://cp2-test.example.org/fhirr4/HealthcareService/08013141-16b2-42a0-8c9a-af57cee5511b"
    }
  ],
  "active" : true,
  "providedBy" : {
    "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067"
  },
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11429006",
          "display" : "Consultation"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "urn:oid:2.16.840.1.113883.2.4.6.7",
          "code" : "0306",
          "display" : "Medisch specialisten, urologie"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://fhir.nl/fhir/NamingSystem/uzi-rolcode",
          "code" : "01.045",
          "display" : "Uroloog"
        }
      ]
    }
  ],
  "name" : "Urologie"
}

```
