# Bundle of personal health information in HIS of Organization 1 - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of personal health information in HIS of Organization 1**

## Example Bundle: Bundle of personal health information in HIS of Organization 1

Bundle phi-org1 of type transaction

-------

Entry 1 - fullUrl = urn:uuid:128447d2-e153-4c93-8ac6-6c357555f3db

Resource Patient:

> 

Profile: [nl core Patient](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient)

Jaantje Merkens Female, DoB: 1950-02-26 ( http://organization1.example.org/EHR/patients#123456)
-------

Request:

```
PUT Patient/128447d2-e153-4c93-8ac6-6c357555f3db

```

-------

Entry 2 - fullUrl = urn:uuid:8cdd8f8d-f75b-4285-851e-ff302dad46fb

Resource Condition:

> 

version: 1; Last updated: 2024-09-03 12:00:00+0000

Profile: [http://nictiz.nl/fhir/StructureDefinition/nl-core-Condition](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Condition)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb**clinicalStatus**:Active**verificationStatus**:Provisional**code**:General weakness**bodySite**:Lower extremity or both lower extremities**subject**:[Patient Jaantje Merkens](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)**onset**: 2021-08-01 00:00:00+0000**note**:
> 

Patient reports general weakness and loss of energy in legs.



Request:

```
PUT Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb

```

-------

Entry 3 - fullUrl = urn:uuid:73f4bffe-eac4-4863-8e4a-852c578f95dd

Resource ServiceRequest:

> 

version: 1

Profile: [nl core Procedure request](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/ServiceRequest/73f4bffe-eac4-4863-8e4a-852c578f95dd**status**: Active**intent**: Order**code**: No display for ServiceRequest.code (concept: Consultation)**subject**:[Patient Jaantje Merkens](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)**requester**:[Caroline van Dijk at Organization 1](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)**performerType**:Vascular medicine

Request:

```
PUT ServiceRequest/73f4bffe-eac4-4863-8e4a-852c578f95dd

```

-------

Entry 4 - fullUrl = urn:uuid:d2f1d123-9bfb-485f-8b6f-2db411c4884e

Resource ServiceRequest:

> 

version: 1

Profile: [nl core Procedure request](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/ServiceRequest/d2f1d123-9bfb-485f-8b6f-2db411c4884e**status**: Active**intent**: Order**code**: No display for ServiceRequest.code (concept: Consultation)**subject**:[Patient Jaantje Merkens](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)**requester**:[Caroline van Dijk at Organization 1](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)**performerType**:Neurology

Request:

```
PUT ServiceRequest/d2f1d123-9bfb-485f-8b6f-2db411c4884e

```

-------

Entry 5 - fullUrl = urn:uuid:4e4215a2-d6ff-4e53-8737-d9810a4cc3eb

Resource ServiceRequest:

> 

version: 1

Profile: [nl core Procedure request](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/ServiceRequest/4e4215a2-d6ff-4e53-8737-d9810a4cc3eb**status**: Active**intent**: Order**code**: No display for ServiceRequest.code (concept: Consultation)**subject**:[Patient Jaantje Merkens](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)**requester**:[Caroline van Dijk at Organization 1](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)**performerType**:Orthopedic specialty

Request:

```
PUT ServiceRequest/4e4215a2-d6ff-4e53-8737-d9810a4cc3eb

```

-------

Entry 6 - fullUrl = urn:uuid:3cb7873f-c222-4196-b441-02b3790ec97e

Resource ServiceRequest:

> 

version: 1

Profile: [nl core Procedure request](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/ServiceRequest/3cb7873f-c222-4196-b441-02b3790ec97e**status**: Active**intent**: Order**code**: No display for ServiceRequest.code (concept: Consultation)**subject**:[Patient Jaantje Merkens](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)**requester**:[Caroline van Dijk at Organization 1](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)**performerType**:Internal medicine

Request:

```
PUT ServiceRequest/3cb7873f-c222-4196-b441-02b3790ec97e

```

-------

Entry 7 - fullUrl = urn:uuid:98f9d4a7-d58d-4889-8e63-0cb2d4e35144

Resource MedicationStatement:

> 

Profile: [http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement)

**status**: active**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/MedicationStatement/98f9d4a7-d58d-4889-8e63-0cb2d4e35144**status**: recorded**subject**:[Jaantje Merkens Female, DoB: 1950-02-26 ( http://organization1.example.org/EHR/patients#123456)](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)**effective**: 2017-09-03**dateAsserted**: 2017-09-03**informationSource**:[PractitionerRole Huisarts](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)
> **dosage****text**: Take one tablet by mouth twice daily**timing**: 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 500 mg |



Request:

```
PUT MedicationStatement/98f9d4a7-d58d-4889-8e63-0cb2d4e35144

```

-------

Entry 8 - fullUrl = urn:uuid:f304c628-c19f-4207-adfb-ad34447ab044

Resource CareTeam:

> **identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/CareTeam/f304c628-c19f-4207-adfb-ad34447ab044
> **participant****member**:[Jaantje Merkens Female, DoB: 1950-02-26 ( http://organization1.example.org/EHR/patients#123456)](Bundle-phi-org1.md#Patient_128447d2-e153-4c93-8ac6-6c357555f3db)

> **participant****member**:[PractitionerRole Huisarts](PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.md)

> **participant****member**: Cardioloog Caroline van Dijk at Organization 2 (Identifier:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba)

> **participant****member**: Klinisch geriater John Doe at Organization 3 (Identifier:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de)

> **participant****member**:[Organization example General Practice](Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.md)

> **participant****member**: example Hospital (Identifier: Ura/22222222)

Request:

```
PUT CareTeam/f304c628-c19f-4207-adfb-ad34447ab044

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "phi-org1",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:128447d2-e153-4c93-8ac6-6c357555f3db",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "128447d2-e153-4c93-8ac6-6c357555f3db",
        "meta" : {
          "profile" : ["http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_128447d2-e153-4c93-8ac6-6c357555f3db\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 128447d2-e153-4c93-8ac6-6c357555f3db</b></p><a name=\"128447d2-e153-4c93-8ac6-6c357555f3db\"> </a><a name=\"hc128447d2-e153-4c93-8ac6-6c357555f3db\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient\">nl core Patient</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization1.example.org/EHR/patients#123456)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Ids (see the one above)\">Other Ids:</td><td colspan=\"3\"><ul><li><code>http://fhir.nl/fhir/NamingSystem/bsn</code>/111222333</li><li><a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp2-test.example.org/fhirr4/Patient/128447d2-e153-4c93-8ac6-6c357555f3db</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li><a href=\"tel:+31612345678\">+31612345678</a></li><li><a href=\"mailto:j.merkens@bigtech.com\">j.merkens@bigtech.com</a></li><li>Kerkstraat 18 Ulft 7071 WZ </li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>Managing Organization: <a href=\"Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.html\">Organization 1</a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://organization1.example.org/EHR/patients",
            "value" : "123456"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
            "value" : "111222333"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp2-test.example.org/fhirr4/Patient/128447d2-e153-4c93-8ac6-6c357555f3db"
          }
        ],
        "name" : [
          {
            "family" : "Merkens",
            "given" : ["Jaantje"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31612345678"
          },
          {
            "system" : "email",
            "value" : "j.merkens@bigtech.com"
          }
        ],
        "gender" : "female",
        "birthDate" : "1950-02-26",
        "address" : [
          {
            "line" : ["Kerkstraat 18"],
            "city" : "Ulft",
            "postalCode" : "7071 WZ"
          }
        ],
        "managingOrganization" : {
          "reference" : "Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec",
          "display" : "Organization 1"
        }
      },
      "request" : {
        "method" : "PUT",
        "url" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db"
      }
    },
    {
      "fullUrl" : "urn:uuid:8cdd8f8d-f75b-4285-851e-ff302dad46fb",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "8cdd8f8d-f75b-4285-851e-ff302dad46fb",
        "meta" : {
          "versionId" : "1",
          "lastUpdated" : "2024-09-03T12:00:00Z",
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-Condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_8cdd8f8d-f75b-4285-851e-ff302dad46fb\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition 8cdd8f8d-f75b-4285-851e-ff302dad46fb</b></p><a name=\"8cdd8f8d-f75b-4285-851e-ff302dad46fb\"> </a><a name=\"hc8cdd8f8d-f75b-4285-851e-ff302dad46fb\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1; Last updated: 2024-09-03 12:00:00+0000</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Condition\">http://nictiz.nl/fhir/StructureDefinition/nl-core-Condition</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb</p><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status provisional}\">Provisional</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 13791008}\">General weakness</span></p><p><b>bodySite</b>: <span title=\"Codes:{http://snomed.info/sct 421480009}\">Lower extremity or both lower extremities</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Patient Jaantje Merkens</a></p><p><b>onset</b>: 2021-08-01 00:00:00+0000</p><p><b>recorder</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">Caroline van Dijk at Organization 1</a></p><p><b>note</b>: </p><blockquote><div><p>Patient reports general weakness and loss of energy in legs.</p>\n</div></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb"
          }
        ],
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "provisional"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "13791008",
              "display" : "General weakness"
            }
          ]
        },
        "bodySite" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "421480009",
                "display" : "Lower extremity or both lower extremities"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db",
          "display" : "Patient Jaantje Merkens"
        },
        "onsetDateTime" : "2021-08-01T00:00:00Z",
        "recorder" : {
          "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
          "display" : "Caroline van Dijk at Organization 1"
        },
        "note" : [
          {
            "text" : "Patient reports general weakness and loss of energy in legs."
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb"
      }
    },
    {
      "fullUrl" : "urn:uuid:73f4bffe-eac4-4863-8e4a-852c578f95dd",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "73f4bffe-eac4-4863-8e4a-852c578f95dd",
        "meta" : {
          "versionId" : "1",
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_73f4bffe-eac4-4863-8e4a-852c578f95dd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest 73f4bffe-eac4-4863-8e4a-852c578f95dd</b></p><a name=\"73f4bffe-eac4-4863-8e4a-852c578f95dd\"> </a><a name=\"hc73f4bffe-eac4-4863-8e4a-852c578f95dd\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request\">nl core Procedure request</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/ServiceRequest/73f4bffe-eac4-4863-8e4a-852c578f95dd</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Patient Jaantje Merkens</a></p><p><b>requester</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">Caroline van Dijk at Organization 1</a></p><p><b>performerType</b>: <span title=\"Codes:{http://snomed.info/sct 722414000}\">Vascular medicine</span></p><p><b>reasonReference</b>: <a href=\"Bundle-phi-org1.html#Condition_8cdd8f8d-f75b-4285-851e-ff302dad46fb\">General Weakness</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/ServiceRequest/73f4bffe-eac4-4863-8e4a-852c578f95dd"
          }
        ],
        "status" : "active",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "11429006",
              "display" : "Consultation"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db",
          "display" : "Patient Jaantje Merkens"
        },
        "requester" : {
          "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
          "display" : "Caroline van Dijk at Organization 1"
        },
        "performerType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "722414000",
              "display" : "Vascular medicine"
            }
          ]
        },
        "reasonReference" : [
          {
            "reference" : "Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb",
            "display" : "General Weakness"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "ServiceRequest/73f4bffe-eac4-4863-8e4a-852c578f95dd"
      }
    },
    {
      "fullUrl" : "urn:uuid:d2f1d123-9bfb-485f-8b6f-2db411c4884e",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "d2f1d123-9bfb-485f-8b6f-2db411c4884e",
        "meta" : {
          "versionId" : "1",
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_d2f1d123-9bfb-485f-8b6f-2db411c4884e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest d2f1d123-9bfb-485f-8b6f-2db411c4884e</b></p><a name=\"d2f1d123-9bfb-485f-8b6f-2db411c4884e\"> </a><a name=\"hcd2f1d123-9bfb-485f-8b6f-2db411c4884e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request\">nl core Procedure request</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/ServiceRequest/d2f1d123-9bfb-485f-8b6f-2db411c4884e</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Patient Jaantje Merkens</a></p><p><b>requester</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">Caroline van Dijk at Organization 1</a></p><p><b>performerType</b>: <span title=\"Codes:{http://snomed.info/sct 394591006}\">Neurology</span></p><p><b>reasonReference</b>: <a href=\"Bundle-phi-org1.html#Condition_8cdd8f8d-f75b-4285-851e-ff302dad46fb\">General Weakness</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/ServiceRequest/d2f1d123-9bfb-485f-8b6f-2db411c4884e"
          }
        ],
        "status" : "active",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "11429006",
              "display" : "Consultation"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db",
          "display" : "Patient Jaantje Merkens"
        },
        "requester" : {
          "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
          "display" : "Caroline van Dijk at Organization 1"
        },
        "performerType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "394591006",
              "display" : "Neurology"
            }
          ]
        },
        "reasonReference" : [
          {
            "reference" : "Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb",
            "display" : "General Weakness"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "ServiceRequest/d2f1d123-9bfb-485f-8b6f-2db411c4884e"
      }
    },
    {
      "fullUrl" : "urn:uuid:4e4215a2-d6ff-4e53-8737-d9810a4cc3eb",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "4e4215a2-d6ff-4e53-8737-d9810a4cc3eb",
        "meta" : {
          "versionId" : "1",
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_4e4215a2-d6ff-4e53-8737-d9810a4cc3eb\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest 4e4215a2-d6ff-4e53-8737-d9810a4cc3eb</b></p><a name=\"4e4215a2-d6ff-4e53-8737-d9810a4cc3eb\"> </a><a name=\"hc4e4215a2-d6ff-4e53-8737-d9810a4cc3eb\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request\">nl core Procedure request</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/ServiceRequest/4e4215a2-d6ff-4e53-8737-d9810a4cc3eb</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Patient Jaantje Merkens</a></p><p><b>requester</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">Caroline van Dijk at Organization 1</a></p><p><b>performerType</b>: <span title=\"Codes:{http://snomed.info/sct 1345026002}\">Orthopedic specialty</span></p><p><b>reasonReference</b>: <a href=\"Bundle-phi-org1.html#Condition_8cdd8f8d-f75b-4285-851e-ff302dad46fb\">General Weakness</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/ServiceRequest/4e4215a2-d6ff-4e53-8737-d9810a4cc3eb"
          }
        ],
        "status" : "active",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "11429006",
              "display" : "Consultation"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db",
          "display" : "Patient Jaantje Merkens"
        },
        "requester" : {
          "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
          "display" : "Caroline van Dijk at Organization 1"
        },
        "performerType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1345026002",
              "display" : "Orthopedic specialty"
            }
          ]
        },
        "reasonReference" : [
          {
            "reference" : "Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb",
            "display" : "General Weakness"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "ServiceRequest/4e4215a2-d6ff-4e53-8737-d9810a4cc3eb"
      }
    },
    {
      "fullUrl" : "urn:uuid:3cb7873f-c222-4196-b441-02b3790ec97e",
      "resource" : {
        "resourceType" : "ServiceRequest",
        "id" : "3cb7873f-c222-4196-b441-02b3790ec97e",
        "meta" : {
          "versionId" : "1",
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ServiceRequest_3cb7873f-c222-4196-b441-02b3790ec97e\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ServiceRequest 3cb7873f-c222-4196-b441-02b3790ec97e</b></p><a name=\"3cb7873f-c222-4196-b441-02b3790ec97e\"> </a><a name=\"hc3cb7873f-c222-4196-b441-02b3790ec97e\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">version: 1</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure-request\">nl core Procedure request</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/ServiceRequest/3cb7873f-c222-4196-b441-02b3790ec97e</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 11429006}\">Consultation</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Patient Jaantje Merkens</a></p><p><b>requester</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">Caroline van Dijk at Organization 1</a></p><p><b>performerType</b>: <span title=\"Codes:{http://snomed.info/sct 419192003}\">Internal medicine</span></p><p><b>reasonReference</b>: <a href=\"Bundle-phi-org1.html#Condition_8cdd8f8d-f75b-4285-851e-ff302dad46fb\">General Weakness</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/ServiceRequest/3cb7873f-c222-4196-b441-02b3790ec97e"
          }
        ],
        "status" : "active",
        "intent" : "order",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "11429006",
              "display" : "Consultation"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db",
          "display" : "Patient Jaantje Merkens"
        },
        "requester" : {
          "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53",
          "display" : "Caroline van Dijk at Organization 1"
        },
        "performerType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "419192003",
              "display" : "Internal medicine"
            }
          ]
        },
        "reasonReference" : [
          {
            "reference" : "Condition/8cdd8f8d-f75b-4285-851e-ff302dad46fb",
            "display" : "General Weakness"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "ServiceRequest/3cb7873f-c222-4196-b441-02b3790ec97e"
      }
    },
    {
      "fullUrl" : "urn:uuid:98f9d4a7-d58d-4889-8e63-0cb2d4e35144",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "98f9d4a7-d58d-4889-8e63-0cb2d4e35144",
        "meta" : {
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_98f9d4a7-d58d-4889-8e63-0cb2d4e35144\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 98f9d4a7-d58d-4889-8e63-0cb2d4e35144</b></p><a name=\"98f9d4a7-d58d-4889-8e63-0cb2d4e35144\"> </a><a name=\"hc98f9d4a7-d58d-4889-8e63-0cb2d4e35144\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement\">http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/MedicationStatement/98f9d4a7-d58d-4889-8e63-0cb2d4e35144</p><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc B01AD04}\">urokinase</span></p><p><b>subject</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization1.example.org/EHR/patients#123456)</a></p><p><b>effective</b>: 2017-09-03</p><p><b>dateAsserted</b>: 2017-09-03</p><p><b>informationSource</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">PractitionerRole Huisarts</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Take one tablet by mouth twice daily</p><p><b>timing</b>: 2 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>500 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/MedicationStatement/98f9d4a7-d58d-4889-8e63-0cb2d4e35144"
          }
        ],
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "B01AD04",
              "display" : "urokinase"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db"
        },
        "effectiveDateTime" : "2017-09-03",
        "dateAsserted" : "2017-09-03",
        "informationSource" : {
          "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53"
        },
        "dosage" : [
          {
            "text" : "Take one tablet by mouth twice daily",
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 500,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "MedicationStatement/98f9d4a7-d58d-4889-8e63-0cb2d4e35144"
      }
    },
    {
      "fullUrl" : "urn:uuid:f304c628-c19f-4207-adfb-ad34447ab044",
      "resource" : {
        "resourceType" : "CareTeam",
        "id" : "f304c628-c19f-4207-adfb-ad34447ab044",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CareTeam_f304c628-c19f-4207-adfb-ad34447ab044\"> </a><p class=\"res-header-id\"><b>Generated Narrative: CareTeam f304c628-c19f-4207-adfb-ad34447ab044</b></p><a name=\"f304c628-c19f-4207-adfb-ad34447ab044\"> </a><a name=\"hcf304c628-c19f-4207-adfb-ad34447ab044\"> </a><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/CareTeam/f304c628-c19f-4207-adfb-ad34447ab044</p><blockquote><p><b>participant</b></p><p><b>member</b>: <a href=\"Bundle-phi-org1.html#Patient_128447d2-e153-4c93-8ac6-6c357555f3db\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization1.example.org/EHR/patients#123456)</a></p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: <a href=\"PractitionerRole-5fa4c91a-a12f-48ae-a4c7-92971dc7ab53.html\">PractitionerRole Huisarts</a></p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: Cardioloog Caroline van Dijk at Organization 2 (Identifier: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba)</p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: Klinisch geriater John Doe at Organization 3 (Identifier: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de)</p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: <a href=\"Organization-4cb35b96-f021-4e15-bf71-d67a6d4bebec.html\">Organization example General Practice</a></p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote><blockquote><p><b>participant</b></p><p><b>member</b>: example Hospital (Identifier: Ura/22222222)</p><p><b>period</b>: 2024-08-27 --&gt; (ongoing)</p></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/CareTeam/f304c628-c19f-4207-adfb-ad34447ab044"
          }
        ],
        "participant" : [
          {
            "member" : {
              "reference" : "Patient/128447d2-e153-4c93-8ac6-6c357555f3db"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "reference" : "PractitionerRole/5fa4c91a-a12f-48ae-a4c7-92971dc7ab53"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "identifier" : {
                "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
                "value" : "https://cp2-test.example.org/fhirr4/PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba"
              },
              "display" : "Cardioloog Caroline van Dijk at Organization 2"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "identifier" : {
                "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
                "value" : "https://cp3-test.example.org/fhirr4/PractitionerRole/d60525bd-5caf-4437-8f4b-4156300a27de"
              },
              "display" : "Klinisch geriater John Doe at Organization 3"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "reference" : "Organization/4cb35b96-f021-4e15-bf71-d67a6d4bebec",
              "identifier" : {
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "11111111"
              }
            },
            "period" : {
              "start" : "2024-08-27"
            }
          },
          {
            "member" : {
              "identifier" : {
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              },
              "display" : "example Hospital"
            },
            "period" : {
              "start" : "2024-08-27"
            }
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "CareTeam/f304c628-c19f-4207-adfb-ad34447ab044"
      }
    }
  ]
}

```
