# Bundle of care services in LRZa - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of care services in LRZa**

## Example Bundle: Bundle of care services in LRZa

Bundle admin-directory-lrza of type transaction

-------

Entry 1 - fullUrl = urn:uuid:3f39dca9-a392-4eb3-8366-0c7ff53ab3a9

Resource Organization:

> 

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/11111111,[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9**type**:Huisartspraktijk (zelfstandig of groepspraktijk)**name**: example General Practice
> **contact****telecom**:[+3131599991](tel:+3131599991),[info@cp1.example.org](mailto:info@cp1.example.org)**address**: Vogelenzangweg 31 null null Ulft 7071 PT
**endpoint**:[Endpoint FHIR Endpoint 1](Endpoint-ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4.md)

Request:

```
PUT Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9

```

-------

Entry 2 - fullUrl = urn:uuid:ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4

Resource Endpoint:

> 

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp1-test.example.org/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 1**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/51494752**contact**:[+3131599991](tel:+3131599991),[info@cp1.example.org](mailto:info@cp1.example.org)**address**:[https://cp1-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4)

Request:

```
PUT Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4

```

-------

Entry 3 - fullUrl = urn:uuid:4815bbe6-9fea-4875-a16c-a168d63054d4

Resource Organization:

> 

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222,[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp2-test.example.org/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4**type**:Ziekenhuis,Hospital**name**: example Hospital
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@cp2.example.org](mailto:info@cp2.example.org)**address**: Catharinastraat 21 Doetinchem 7001 BZ
**endpoint**:[Endpoint FHIR Endpoint 2](Endpoint-960a4f8c-74d8-482c-97ab-e2a025869fee.md)

Request:

```
PUT Organization/4815bbe6-9fea-4875-a16c-a168d63054d4

```

-------

Entry 4 - fullUrl = urn:uuid:960a4f8c-74d8-482c-97ab-e2a025869fee

Resource Endpoint:

> 

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp2-test.example.org/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 2**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/08013836**contact**:[+3131599991](tel:+3131599991),[info@nedap.example.org](mailto:info@nedap.example.org)**address**:[https://cp2-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp2-test.example.org/fhirr4)

Request:

```
PUT Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee

```

-------

Entry 5 - fullUrl = urn:uuid:fcf55b06-f22c-4058-9051-b77368bdd26b

Resource Organization:

> 

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/33333333,[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp3-test.example.org/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b**type**:Verplegings- of verzorgingsinstelling**name**: example Care Institution
> **contact****telecom**:[+31301234567](tel:+31301234567),[info@organization3.nl](mailto:info@organization3.nl)**address**: Smidsstraat 10 Zelhem 7021 AC
**endpoint**:[Endpoint FHIR Endpoint 3](Endpoint-553416dd-da12-40f7-a9bd-eb3e193177bd.md)

Request:

```
PUT Organization/fcf55b06-f22c-4058-9051-b77368bdd26b

```

-------

Entry 6 - fullUrl = urn:uuid:553416dd-da12-40f7-a9bd-eb3e193177bd

Resource Endpoint:

> 

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**:[FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp3-test.example.org/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd**status**: Active**connectionType**:HL7 FHIR**name**: FHIR Endpoint 3**managingOrganization**: Identifier:`http://fhir.nl/fhir/NamingSystem/kvk`/34270859**contact**:[+3131599991](tel:+3131599991),[info@example.org](mailto:info@example.org)**address**:[https://cp3-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4)

Request:

```
PUT Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "admin-directory-lrza",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:3f39dca9-a392-4eb3-8366-0c7ff53ab3a9",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "3f39dca9-a392-4eb3-8366-0c7ff53ab3a9",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_3f39dca9-a392-4eb3-8366-0c7ff53ab3a9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 3f39dca9-a392-4eb3-8366-0c7ff53ab3a9</b></p><a name=\"3f39dca9-a392-4eb3-8366-0c7ff53ab3a9\"> </a><a name=\"hc3f39dca9-a392-4eb3-8366-0c7ff53ab3a9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/11111111, <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type Z3}\">Huisartspraktijk (zelfstandig of groepspraktijk)</span></p><p><b>name</b>: example General Practice</p><p><b>telecom</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>address</b>: Vogelenzangweg 31 null null Ulft 7071 PT </p><p><b>endpoint</b>: <a href=\"Endpoint-ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4.html\">Endpoint FHIR Endpoint 1</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "11111111"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "Z3",
                "display" : "Huisartspraktijk (zelfstandig of groepspraktijk)"
              }
            ]
          }
        ],
        "name" : "example General Practice",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Vogelenzangweg 31", null, null],
            "_line" : [
              null,
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Vogelenzangweg"
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "31"
                  }
                ]
              }
            ],
            "city" : "Ulft",
            "postalCode" : "7071 PT"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/3f39dca9-a392-4eb3-8366-0c7ff53ab3a9"
      }
    },
    {
      "fullUrl" : "urn:uuid:ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4</b></p><a name=\"ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4\"> </a><a name=\"hcffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp1-test.example.org/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: FHIR Endpoint 1</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/51494752</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@cp1.example.org\">info@cp1.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp1-test.example.org/fhirr4\">https://cp1-test.example.org/fhirr4</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp1-test.example.org/fhirr4/Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4"
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 1",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "51494752"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp1.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp1-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4"
      }
    },
    {
      "fullUrl" : "urn:uuid:4815bbe6-9fea-4875-a16c-a168d63054d4",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "4815bbe6-9fea-4875-a16c-a168d63054d4",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_4815bbe6-9fea-4875-a16c-a168d63054d4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 4815bbe6-9fea-4875-a16c-a168d63054d4</b></p><a name=\"4815bbe6-9fea-4875-a16c-a168d63054d4\"> </a><a name=\"hc4815bbe6-9fea-4875-a16c-a168d63054d4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/22222222, <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp2-test.example.org/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type V4}\">Ziekenhuis</span>, <span title=\"Codes:{http://snomed.info/sct 22232009}\">Hospital</span></p><p><b>name</b>: example Hospital</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@cp2.example.org\">info@cp2.example.org</a></p><p><b>address</b>: Catharinastraat 21 Doetinchem 7001 BZ </p><p><b>endpoint</b>: <a href=\"Endpoint-960a4f8c-74d8-482c-97ab-e2a025869fee.html\">Endpoint FHIR Endpoint 2</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "22222222"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp2-test.example.org/fhirr4/Organization/4815bbe6-9fea-4875-a16c-a168d63054d4"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "V4",
                "display" : "Ziekenhuis"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "22232009",
                "display" : "Hospital"
              }
            ]
          }
        ],
        "name" : "example Hospital",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@cp2.example.org",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Catharinastraat 21"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Catharinastraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "21"
                  }
                ]
              }
            ],
            "city" : "Doetinchem",
            "postalCode" : "7001 BZ"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/4815bbe6-9fea-4875-a16c-a168d63054d4"
      }
    },
    {
      "fullUrl" : "urn:uuid:960a4f8c-74d8-482c-97ab-e2a025869fee",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "960a4f8c-74d8-482c-97ab-e2a025869fee",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_960a4f8c-74d8-482c-97ab-e2a025869fee\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 960a4f8c-74d8-482c-97ab-e2a025869fee</b></p><a name=\"960a4f8c-74d8-482c-97ab-e2a025869fee\"> </a><a name=\"hc960a4f8c-74d8-482c-97ab-e2a025869fee\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp2-test.example.org/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: FHIR Endpoint 2</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/08013836</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@nedap.example.org\">info@nedap.example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp2-test.example.org/fhirr4\">https://cp2-test.example.org/fhirr4</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp2-test.example.org/fhirr4/Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee"
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 2",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "08013836"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@nedap.example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp2-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/960a4f8c-74d8-482c-97ab-e2a025869fee"
      }
    },
    {
      "fullUrl" : "urn:uuid:fcf55b06-f22c-4058-9051-b77368bdd26b",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "fcf55b06-f22c-4058-9051-b77368bdd26b",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_fcf55b06-f22c-4058-9051-b77368bdd26b\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization fcf55b06-f22c-4058-9051-b77368bdd26b</b></p><a name=\"fcf55b06-f22c-4058-9051-b77368bdd26b\"> </a><a name=\"hcfcf55b06-f22c-4058-9051-b77368bdd26b\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-organization.html\">NL Generic Functions Organization Profile</a></p></div><p><b>identifier</b>: Ura/33333333, <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp3-test.example.org/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b</p><p><b>type</b>: <span title=\"Codes:{http://nictiz.nl/fhir/NamingSystem/organization-type X3}\">Verplegings- of verzorgingsinstelling</span></p><p><b>name</b>: example Care Institution</p><p><b>telecom</b>: <a href=\"tel:+31301234567\">+31301234567</a>, <a href=\"mailto:info@organization3.nl\">info@organization3.nl</a></p><p><b>address</b>: Smidsstraat 10 Zelhem 7021 AC </p><p><b>endpoint</b>: <a href=\"Endpoint-553416dd-da12-40f7-a9bd-eb3e193177bd.html\">Endpoint FHIR Endpoint 3</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/ura",
            "value" : "33333333"
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp3-test.example.org/fhirr4/Organization/fcf55b06-f22c-4058-9051-b77368bdd26b"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
                "code" : "X3",
                "display" : "Verplegings- of verzorgingsinstelling"
              }
            ]
          }
        ],
        "name" : "example Care Institution",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31301234567",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@organization3.nl",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "line" : ["Smidsstraat 10"],
            "_line" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                    "valueString" : "Smidsstraat"
                  },
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                    "valueString" : "10"
                  }
                ]
              }
            ],
            "city" : "Zelhem",
            "postalCode" : "7021 AC"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Organization/fcf55b06-f22c-4058-9051-b77368bdd26b"
      }
    },
    {
      "fullUrl" : "urn:uuid:553416dd-da12-40f7-a9bd-eb3e193177bd",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "553416dd-da12-40f7-a9bd-eb3e193177bd",
        "meta" : {
          "profile" : [
            "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_553416dd-da12-40f7-a9bd-eb3e193177bd\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint 553416dd-da12-40f7-a9bd-eb3e193177bd</b></p><a name=\"553416dd-da12-40f7-a9bd-eb3e193177bd\"> </a><a name=\"hc553416dd-da12-40f7-a9bd-eb3e193177bd\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-nl-gf-endpoint.html\">NL Generic Functions Endpoint Profile</a></p></div><p><b>identifier</b>: <a href=\"NamingSystem-fhir-resource-url.html\" title=\"This identifier represents an URI and URL that is SHOULD resolve/redirect to a FHIR resource for a long term (10+ years); just like 'permalinks' or 'persistent URLs' are used in scientific literature. \r\n\r\nOnly authoritative sources, i.e. the (legal) custodian/data holder should assign these URLs. \r\n\r\nThe custodian is responsible for forwarding/redirecting the URL-host/domain to a specific software system or platform, ensuring long term persistence of the identifier or (external) reference that's pointing to this resource.\">FHIR resource URL</a>/https://cp3-test.example.org/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: FHIR Endpoint 3</p><p><b>managingOrganization</b>: Identifier: <code>http://fhir.nl/fhir/NamingSystem/kvk</code>/34270859</p><p><b>contact</b>: <a href=\"tel:+3131599991\">+3131599991</a>, <a href=\"mailto:info@example.org\">info@example.org</a></p><p><b>payloadType</b>: <span title=\"Codes:{http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client}\">Care Services Directory for Update Client</span></p><p><b>payloadMimeType</b>: application/fhir+json</p><p><b>address</b>: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=https://cp3-test.example.org/fhirr4\">https://cp3-test.example.org/fhirr4</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
            "value" : "https://cp3-test.example.org/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd"
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "FHIR Endpoint 3",
        "managingOrganization" : {
          "identifier" : {
            "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
            "value" : "34270859"
          }
        },
        "contact" : [
          {
            "system" : "phone",
            "value" : "+3131599991",
            "use" : "work"
          },
          {
            "system" : "email",
            "value" : "info@example.org",
            "use" : "work"
          }
        ],
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
                "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
                "display" : "Care Services Directory for Update Client"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+json"],
        "address" : "https://cp3-test.example.org/fhirr4"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd"
      }
    }
  ]
}

```
