# LRZa - Organization 3 - Endpoint - Netherlands - Generic Functions for data exchange Implementation Guide v0.2.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LRZa - Organization 3 - Endpoint**

## Example Endpoint: LRZa - Organization 3 - Endpoint

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**identifier**: [FHIR resource URL](NamingSystem-fhir-resource-url.md)/https://cp3-test.example.org/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/6.5.0/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR Endpoint 3

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/34270859

**contact**: [+3131599991](tel:+3131599991), [info@example.org](mailto:info@example.org)

**payloadType**: Care Services Directory for Update Client

**payloadMimeType**: application/fhir+json

**address**: [https://cp3-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp3-test.example.org/fhirr4)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "553416dd-da12-40f7-a9bd-eb3e193177bd",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/url/fhir",
      "value" : "https://cp3-test.example.org/fhirr4/Endpoint/553416dd-da12-40f7-a9bd-eb3e193177bd"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR Endpoint 3",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "34270859"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
          "display" : "Care Services Directory for Update Client"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp3-test.example.org/fhirr4"
}

```
