# NL Generic Functions Localization List Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Localization List Profile**

## Resource Profile: NL Generic Functions Localization List Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-list | *Version*:0.3.0 |
| Draft as of 2026-02-08 | *Computable Name*:NlGfLocalizationList |

 
A List profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes. 

**Usages:**

* Examples for this Profile: [List/a1b2c3d4-e5f6-7890-abcd-ef1234567890](List-a1b2c3d4-e5f6-7890-abcd-ef1234567890.md)
* CapabilityStatements using this Profile: [Localization Service (List)](CapabilityStatement-nl-gf-localization-repository-list.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-localization-list)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-localization-list.csv), [Excel](StructureDefinition-nl-gf-localization-list.xlsx), [Schematron](StructureDefinition-nl-gf-localization-list.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-localization-list",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-list",
  "version" : "0.3.0",
  "name" : "NlGfLocalizationList",
  "title" : "NL Generic Functions Localization List Profile",
  "status" : "draft",
  "date" : "2026-02-08T14:12:12+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "A List profile for registering the availability of patient data\nat healthcare organizations for localization services. This profile is used to\nindicate that certain patient data is available at a specific organization and\ncan be accessed for localization purposes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "List",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/List",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "List",
        "path" : "List"
      },
      {
        "id" : "List.extension",
        "path" : "List.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "List.extension:custodian",
        "path" : "List.extension",
        "sliceName" : "custodian",
        "comment" : "The Organization which published the data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-custodian"
            ]
          }
        ]
      },
      {
        "id" : "List.identifier",
        "path" : "List.identifier",
        "comment" : "Prohibited to prevent linkable information",
        "max" : "0"
      },
      {
        "id" : "List.status",
        "path" : "List.status",
        "comment" : "All records are always current",
        "patternCode" : "current"
      },
      {
        "id" : "List.mode",
        "path" : "List.mode",
        "patternCode" : "working"
      },
      {
        "id" : "List.code",
        "path" : "List.code",
        "min" : 1,
        "binding" : {
          "strength" : "required",
          "valueSet" : "urn:oid:2.16.840.1.113883.2.4.3.111.3.3.11.2"
        }
      },
      {
        "id" : "List.subject",
        "path" : "List.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Patient"]
          }
        ]
      },
      {
        "id" : "List.subject.reference",
        "path" : "List.subject.reference",
        "max" : "0"
      },
      {
        "id" : "List.subject.identifier",
        "path" : "List.subject.identifier",
        "min" : 1
      },
      {
        "id" : "List.subject.identifier.system",
        "path" : "List.subject.identifier.system",
        "patternUri" : "http://fhir.nl/fhir/NamingSystem/pseudo-bsn"
      },
      {
        "id" : "List.source",
        "path" : "List.source",
        "max" : "0"
      },
      {
        "id" : "List.entry",
        "path" : "List.entry",
        "max" : "0"
      },
      {
        "id" : "List.emptyReason",
        "path" : "List.emptyReason",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
              "code" : "withheld"
            }
          ]
        }
      }
    ]
  }
}

```
