# Organization 2 - Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Organization 2 - Organization**

## Example Organization: Organization 2 - Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization.md)

**identifier**: Ura/22222222, `https://cp2-test.example.org/departments`/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067

**type**: Ziekenhuis, Hospital

**name**: example Hospital

**telecom**: [+31301234567](tel:+31301234567), [info@cp2.example.org](mailto:info@cp2.example.org)

**address**: Catharinastraat 21 Doetinchem 7001 BZ 

**endpoint**: 

* [Endpoint FHIR Endpoint 2](Endpoint-430f7379-8ec2-4e55-b096-919995da61e2.md)
* [Endpoint DICOM-WADO-RS Endpoint](Endpoint-d4c1d657-67a9-471c-9732-9c042e9a6d43.md)
* [Endpoint FHIR STU3 Endpoint](Endpoint-2427ca0c-8a29-4a6a-aabd-50cf02f587a7.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "22222222"
    },
    {
      "system" : "https://cp2-test.example.org/departments",
      "value" : "cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/ura",
          "value" : "22222222"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "V4",
          "display" : "Ziekenhuis"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "22232009",
          "display" : "Hospital"
        }
      ]
    }
  ],
  "name" : "example Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234567",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp2.example.org",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Catharinastraat 21"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Catharinastraat"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "21"
            }
          ]
        }
      ],
      "city" : "Doetinchem",
      "postalCode" : "7001 BZ"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/430f7379-8ec2-4e55-b096-919995da61e2"
    },
    {
      "reference" : "Endpoint/d4c1d657-67a9-471c-9732-9c042e9a6d43"
    },
    {
      "reference" : "Endpoint/2427ca0c-8a29-4a6a-aabd-50cf02f587a7"
    }
  ]
}

```
