# LRZa - Organization 1 - Endpoint - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LRZa - Organization 1 - Endpoint**

## Example Endpoint: LRZa - Organization 1 - Endpoint

Profile: [NL Generic Functions Endpoint Profile](StructureDefinition-nl-gf-endpoint.md)

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: FHIR Endpoint 1

**managingOrganization**: Identifier: `http://fhir.nl/fhir/NamingSystem/kvk`/51494752

**contact**: [+3131599991](tel:+3131599991), [info@cp1.example.org](mailto:info@cp1.example.org)

**payloadType**: Care Services Directory for Update Client

**payloadMimeType**: application/fhir+json

**address**: [https://cp1-test.example.org/fhirr4](https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&canonical=https://cp1-test.example.org/fhirr4)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "ffa3e969-3dfd-45d3-9d2c-f4e3795e1bf4",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-endpoint"
    ]
  },
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "FHIR Endpoint 1",
  "managingOrganization" : {
    "identifier" : {
      "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
      "value" : "51494752"
    }
  },
  "contact" : [
    {
      "system" : "phone",
      "value" : "+3131599991",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp1.example.org",
      "use" : "work"
    }
  ],
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CodeSystem/nl-gf-data-exchange-capabilities",
          "code" : "http://nuts-foundation.github.io/nl-generic-functions-ig/CapabilityStatement/nl-gf-admin-directory-update-client",
          "display" : "Care Services Directory for Update Client"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+json"],
  "address" : "https://cp1-test.example.org/fhirr4"
}

```
