# LRZa - Organization 2 - Organization - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **LRZa - Organization 2 - Organization**

## Example Organization: LRZa - Organization 2 - Organization

Profile: [NL Generic Functions Organization Profile](StructureDefinition-nl-gf-organization-lrza.md)

**identifier**: Ura/22222222

**type**: Ziekenhuis, Hospital

**name**: example Hospital

**telecom**: [+31301234567](tel:+31301234567), [info@cp2.example.org](mailto:info@cp2.example.org)

**address**: Catharinastraat 21 Doetinchem 7001 BZ 

**endpoint**: [Endpoint FHIR Endpoint 2](Endpoint-lrza-e2.md)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "lrza-o2",
  "meta" : {
    "profile" : [
      "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-organization-lrza"
    ]
  },
  "identifier" : [
    {
      "system" : "http://fhir.nl/fhir/NamingSystem/ura",
      "value" : "22222222",
      "assigner" : {
        "identifier" : {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                "code" : "author"
              }
            ]
          },
          "system" : "http://fhir.nl/fhir/NamingSystem/kvk",
          "value" : "50000535"
        }
      }
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://nictiz.nl/fhir/NamingSystem/organization-type",
          "code" : "V4",
          "display" : "Ziekenhuis"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "22232009",
          "display" : "Hospital"
        }
      ]
    }
  ],
  "name" : "example Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+31301234567",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "info@cp2.example.org",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["Catharinastraat 21"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Catharinastraat"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "21"
            }
          ]
        }
      ],
      "city" : "Doetinchem",
      "postalCode" : "7001 BZ"
    }
  ],
  "endpoint" : [
    {
      "reference" : "Endpoint/lrza-e2"
    }
  ]
}

```
