# NL Generic Functions Localization List Profile - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NL Generic Functions Localization List Profile**

## Resource Profile: NL Generic Functions Localization List Profile 

| | |
| :--- | :--- |
| *Official URL*:http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-list | *Version*:0.3.0 |
| Draft as of 2026-02-09 | *Computable Name*:NlGfLocalizationList |

 
A FHIR List profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/fhir.nl.gf|current/StructureDefinition/nl-gf-localization-list)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-nl-gf-localization-list.csv), [Excel](StructureDefinition-nl-gf-localization-list.xlsx), [Schematron](StructureDefinition-nl-gf-localization-list.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "nl-gf-localization-list",
  "url" : "http://nuts-foundation.github.io/nl-generic-functions-ig/StructureDefinition/nl-gf-localization-list",
  "version" : "0.3.0",
  "name" : "NlGfLocalizationList",
  "title" : "NL Generic Functions Localization List Profile",
  "status" : "draft",
  "date" : "2026-02-09T08:42:18+00:00",
  "publisher" : "Stichting Nuts",
  "contact" : [
    {
      "name" : "Stichting Nuts",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.nuts.nl"
        }
      ]
    }
  ],
  "description" : "A FHIR List profile for registering the availability of patient data at healthcare organizations for localization services. This profile is used to indicate that certain patient data is available at a specific organization and can be accessed for localization purposes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "NL",
          "display" : "Netherlands"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "SubmissionSet-Mapping",
      "uri" : "urn:ihe:iti:xds:submissionset",
      "name" : "XDS and MHD Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "List",
  "baseDefinition" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.SubmissionSet",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "List",
        "path" : "List"
      },
      {
        "id" : "List.meta",
        "path" : "List.meta",
        "max" : "0"
      },
      {
        "id" : "List.implicitRules",
        "path" : "List.implicitRules",
        "max" : "0"
      },
      {
        "id" : "List.language",
        "path" : "List.language",
        "max" : "0"
      },
      {
        "id" : "List.text",
        "path" : "List.text",
        "max" : "0"
      },
      {
        "id" : "List.contained",
        "path" : "List.contained",
        "max" : "0"
      },
      {
        "id" : "List.extension:intendedRecipient",
        "path" : "List.extension",
        "sliceName" : "intendedRecipient",
        "max" : "0"
      },
      {
        "id" : "List.title",
        "path" : "List.title",
        "max" : "0"
      },
      {
        "id" : "List.source.extension:authorOrg",
        "path" : "List.source.extension",
        "sliceName" : "authorOrg",
        "max" : "0"
      },
      {
        "id" : "List.source.reference",
        "path" : "List.source.reference",
        "max" : "0"
      },
      {
        "id" : "List.source.type",
        "path" : "List.source.type",
        "patternUri" : "Device"
      },
      {
        "id" : "List.note",
        "path" : "List.note",
        "max" : "0"
      },
      {
        "id" : "List.entry",
        "path" : "List.entry",
        "max" : "0"
      }
    ]
  }
}

```
