# Bundle of personal health information in EHR of Organization 2 - Netherlands - Generic Functions for data exchange Implementation Guide v0.3.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of personal health information in EHR of Organization 2**

## Example Bundle: Bundle of personal health information in EHR of Organization 2



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "phi-org2",
  "type" : "transaction",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:27e58ece-409e-44f9-8cc1-b33495a0ef9d",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "27e58ece-409e-44f9-8cc1-b33495a0ef9d",
        "meta" : {
          "profile" : ["http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_27e58ece-409e-44f9-8cc1-b33495a0ef9d\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 27e58ece-409e-44f9-8cc1-b33495a0ef9d</b></p><a name=\"27e58ece-409e-44f9-8cc1-b33495a0ef9d\"> </a><a name=\"hc27e58ece-409e-44f9-8cc1-b33495a0ef9d\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Patient\">nl core Patient</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>http://fhir.nl/fhir/NamingSystem/bsn</code>/111222333</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li><a href=\"tel:+31612345678\">+31612345678</a></li><li><a href=\"mailto:j.merkens@bigtech.com\">j.merkens@bigtech.com</a></li><li>Kerkstraat 18 Ulft 7071 WZ </li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>Managing Organization: <a href=\"Organization-cff921f3-c1c1-4a4c-8f0f-cafd0aa25067.html\">Organization 2</a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "http://organization2.example.org/EHR/patients",
            "value" : "vdfesz",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              }
            }
          },
          {
            "system" : "http://fhir.nl/fhir/NamingSystem/bsn",
            "value" : "111222333"
          }
        ],
        "name" : [
          {
            "family" : "Merkens",
            "given" : ["Jaantje"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+31612345678"
          },
          {
            "system" : "email",
            "value" : "j.merkens@bigtech.com"
          }
        ],
        "gender" : "female",
        "birthDate" : "1950-02-26",
        "address" : [
          {
            "line" : ["Kerkstraat 18"],
            "city" : "Ulft",
            "postalCode" : "7071 WZ"
          }
        ],
        "managingOrganization" : {
          "reference" : "Organization/cff921f3-c1c1-4a4c-8f0f-cafd0aa25067",
          "display" : "Organization 2"
        }
      },
      "request" : {
        "method" : "PUT",
        "url" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
      }
    },
    {
      "fullUrl" : "urn:uuid:8f26c2c2-9a7b-4a2f-84ac-264f1177964c",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "8f26c2c2-9a7b-4a2f-84ac-264f1177964c",
        "meta" : {
          "profile" : ["http://nictiz.nl/fhir/StructureDefinition/nl-core-Problem"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_8f26c2c2-9a7b-4a2f-84ac-264f1177964c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition 8f26c2c2-9a7b-4a2f-84ac-264f1177964c</b></p><a name=\"8f26c2c2-9a7b-4a2f-84ac-264f1177964c\"> </a><a name=\"hc8f26c2c2-9a7b-4a2f-84ac-264f1177964c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Problem\">nl core Problem</a></p></div><p><b>identifier</b>: <code>https://cp2-test.example.org/Condition</code>/8f26c2c2-9a7b-4a2f-84ac-264f1177964c</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 308546005}\">Dissection of aorta</span></p><p><b>subject</b>: <a href=\"Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.html\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)</a></p><p><b>onset</b>: 2017-09-03 12:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp2-test.example.org/Condition",
            "value" : "8f26c2c2-9a7b-4a2f-84ac-264f1177964c",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              }
            }
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "308546005",
              "display" : "Dissection of aorta"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
        },
        "onsetDateTime" : "2017-09-03T12:00:00Z"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Condition/8f26c2c2-9a7b-4a2f-84ac-264f1177964c"
      }
    },
    {
      "fullUrl" : "urn:uuid:5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757",
        "meta" : {
          "profile" : ["http://nictiz.nl/fhir/StructureDefinition/nl-core-Problem"]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition 5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757</b></p><a name=\"5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757\"> </a><a name=\"hc5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Problem\">nl core Problem</a></p></div><p><b>identifier</b>: <code>https://cp2-test.example.org/Condition</code>/5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 66931009}\">Hypercalcemia</span></p><p><b>subject</b>: <a href=\"Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.html\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)</a></p><p><b>onset</b>: 2021-09-03 12:00:00+0000</p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp2-test.example.org/Condition",
            "value" : "5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              }
            }
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "66931009",
              "display" : "Hypercalcemia"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
        },
        "onsetDateTime" : "2021-09-03T12:00:00Z"
      },
      "request" : {
        "method" : "PUT",
        "url" : "Condition/5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757"
      }
    },
    {
      "fullUrl" : "urn:uuid:6bc0f95c-f281-475e-a279-4ed6beb59024",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "6bc0f95c-f281-475e-a279-4ed6beb59024",
        "meta" : {
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_6bc0f95c-f281-475e-a279-4ed6beb59024\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Procedure 6bc0f95c-f281-475e-a279-4ed6beb59024</b></p><a name=\"6bc0f95c-f281-475e-a279-4ed6beb59024\"> </a><a name=\"hc6bc0f95c-f281-475e-a279-4ed6beb59024\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure\">http://nictiz.nl/fhir/StructureDefinition/nl-core-Procedure</a></p></div><p><b>identifier</b>: <code>https://cp2-test.example.org/Procedure</code>/6bc0f95c-f281-475e-a279-4ed6beb59024</p><p><b>status</b>: Completed</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 13619001}\">Thyroidectomy</span></p><p><b>subject</b>: <a href=\"Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.html\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)</a></p><p><b>performed</b>: 2022-05-15 08:00:00+0000</p><h3>Performers</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Actor</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.html\">PractitionerRole Cardioloog</a></td></tr></table><p><b>reasonReference</b>: <a href=\"Condition-5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757.html\">Condition Hypercalcemia</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp2-test.example.org/Procedure",
            "value" : "6bc0f95c-f281-475e-a279-4ed6beb59024",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              }
            }
          }
        ],
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "13619001",
              "display" : "Thyroidectomy"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
        },
        "performedDateTime" : "2022-05-15T08:00:00Z",
        "performer" : [
          {
            "actor" : {
              "reference" : "PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba"
            }
          }
        ],
        "reasonReference" : [
          {
            "reference" : "Condition/5a7f34e7-9b7b-4e5c-ba7c-890edbc4d757"
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "Procedure/6bc0f95c-f281-475e-a279-4ed6beb59024"
      }
    },
    {
      "fullUrl" : "urn:uuid:8c2d4009-4322-4d4a-8e29-3e70cd67d286",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "8c2d4009-4322-4d4a-8e29-3e70cd67d286",
        "meta" : {
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationRequest"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_8c2d4009-4322-4d4a-8e29-3e70cd67d286\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationRequest 8c2d4009-4322-4d4a-8e29-3e70cd67d286</b></p><a name=\"8c2d4009-4322-4d4a-8e29-3e70cd67d286\"> </a><a name=\"hc8c2d4009-4322-4d4a-8e29-3e70cd67d286\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationRequest\">http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationRequest</a></p></div><p><b>identifier</b>: <code>https://cp2-test.example.org/MedicationRequest</code>/8c2d4009-4322-4d4a-8e29-3e70cd67d286</p><p><b>status</b>: Active</p><p><b>intent</b>: Order</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L01BC05}\">gemcitabine</span></p><p><b>subject</b>: <a href=\"Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.html\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)</a></p><p><b>authoredOn</b>: 2017-09-03</p><p><b>requester</b>: <a href=\"PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.html\">PractitionerRole Cardioloog</a></p><blockquote><p><b>dosageInstruction</b></p><p><b>text</b>: Take one tablet by mouth twice daily</p><p><b>timing</b>: 2 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>250 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp2-test.example.org/MedicationRequest",
            "value" : "8c2d4009-4322-4d4a-8e29-3e70cd67d286",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              }
            }
          }
        ],
        "status" : "active",
        "intent" : "order",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L01BC05",
              "display" : "gemcitabine"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
        },
        "authoredOn" : "2017-09-03",
        "requester" : {
          "reference" : "PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba"
        },
        "dosageInstruction" : [
          {
            "text" : "Take one tablet by mouth twice daily",
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 250,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "MedicationRequest/8c2d4009-4322-4d4a-8e29-3e70cd67d286"
      }
    },
    {
      "fullUrl" : "urn:uuid:e00a59fa-7d7e-422d-8505-ef3e645404e9",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "e00a59fa-7d7e-422d-8505-ef3e645404e9",
        "meta" : {
          "profile" : [
            "http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_e00a59fa-7d7e-422d-8505-ef3e645404e9\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement e00a59fa-7d7e-422d-8505-ef3e645404e9</b></p><a name=\"e00a59fa-7d7e-422d-8505-ef3e645404e9\"> </a><a name=\"hce00a59fa-7d7e-422d-8505-ef3e645404e9\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://simplifier.net/resolve?scope=nictiz.fhir.nl.r4.nl-core@0.12.0-beta.4&amp;canonical=http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement\">http://nictiz.nl/fhir/StructureDefinition/nl-core-MedicationStatement</a></p></div><p><b>identifier</b>: <code>https://cp2-test.example.org/MedicationStatement</code>/e00a59fa-7d7e-422d-8505-ef3e645404e9</p><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{http://www.whocc.no/atc L01BC05}\">gemcitabine</span></p><p><b>subject</b>: <a href=\"Patient-27e58ece-409e-44f9-8cc1-b33495a0ef9d.html\">Jaantje Merkens  Female, DoB: 1950-02-26 ( http://organization2.example.org/EHR/patients#vdfesz)</a></p><p><b>effective</b>: 2017-09-03</p><p><b>dateAsserted</b>: 2017-09-03</p><p><b>informationSource</b>: <a href=\"PractitionerRole-f051d3bd-26ff-4030-a5b6-fc4ef2be83ba.html\">PractitionerRole Cardioloog</a></p><blockquote><p><b>dosage</b></p><p><b>text</b>: Take one tablet by mouth twice daily</p><p><b>timing</b>: 2 per 1 day</p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>250 mg</td></tr></table></blockquote></div>"
        },
        "identifier" : [
          {
            "system" : "https://cp2-test.example.org/MedicationStatement",
            "value" : "e00a59fa-7d7e-422d-8505-ef3e645404e9",
            "assigner" : {
              "identifier" : {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
                      "code" : "author"
                    }
                  ]
                },
                "system" : "http://fhir.nl/fhir/NamingSystem/ura",
                "value" : "22222222"
              }
            }
          }
        ],
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L01BC05",
              "display" : "gemcitabine"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/27e58ece-409e-44f9-8cc1-b33495a0ef9d"
        },
        "effectiveDateTime" : "2017-09-03",
        "dateAsserted" : "2017-09-03",
        "informationSource" : {
          "reference" : "PractitionerRole/f051d3bd-26ff-4030-a5b6-fc4ef2be83ba"
        },
        "dosage" : [
          {
            "text" : "Take one tablet by mouth twice daily",
            "timing" : {
              "repeat" : {
                "frequency" : 2,
                "period" : 1,
                "periodUnit" : "d"
              }
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 250,
                  "unit" : "mg"
                }
              }
            ]
          }
        ]
      },
      "request" : {
        "method" : "PUT",
        "url" : "MedicationStatement/e00a59fa-7d7e-422d-8505-ef3e645404e9"
      }
    }
  ]
}

```
